/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.KSamplePlots;
import org.rosuda.deducer.menu.OneWayPlotModel;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.SubsetPanel;
import org.rosuda.deducer.toolkit.AddButton;
import org.rosuda.deducer.toolkit.AssumptionIcon;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.RemoveButton;
import org.rosuda.deducer.toolkit.SingletonAddRemoveButton;
import org.rosuda.deducer.toolkit.SingletonDJList;
import org.rosuda.deducer.toolkit.VariableSelector;

public class KSampleDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private SingletonDJList factor;
    private JPanel meanPanel;
    private JButton exchAssump;
    private JButton largeAssump2;
    private JSeparator sep;
    private JCheckBox kwTest;
    private JButton eqVarAssump;
    private JPanel okayCancelPanel;
    private JSeparator sep1;
    private JButton help;
    private JButton largeAssump3;
    private JCheckBox median;
    private JButton outliersAssump2;
    private JButton nOrNormAssump;
    private JCheckBox anova;
    private JButton outlierAssump;
    private JButton largeAssump;
    private JCheckBox welch;
    private JPanel medianPanel;
    private JButton plots;
    private JButton pairwise;
    private SubsetPanel subset;
    private JPanel subsetPanel;
    private SingletonAddRemoveButton addFactor;
    private JPanel factorPanel;
    private JButton remove;
    private JButton add;
    private DJList outcomes;
    private JScrollPane outcomeScroller;
    private JPanel outcomePanel;
    private KSampleModel model;
    private static KSampleModel lastModel;

    public KSampleDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        this.variableSelector.getJComboBox().addActionListener(this);
        this.median.setEnabled(false);
        this.largeAssump3.setEnabled(false);
        this.reset();
        if (lastModel != null) {
            this.setModel(lastModel);
        }
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(12, 435, 556, 4, 2, 1, 1, 2));
            this.variableSelector.setPreferredSize(new Dimension(234, 315));
            this.okayCancelPanel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okayCancelPanel, new AnchorConstraint(910, 979, 980, 469, 1, 1, 1, 1));
            this.okayCancelPanel.setPreferredSize(new Dimension(279, 42));
            this.help = new HelpButton("pmwiki.php?n=Main.K-SampleTest");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(943, 97, 970, 22, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.medianPanel = new JPanel();
            this.getContentPane().add((Component)this.medianPanel, new AnchorConstraint(665, 12, 910, 528, 1, 2, 1, 1));
            this.medianPanel.setPreferredSize(new Dimension(247, 144));
            this.medianPanel.setBorder(BorderFactory.createTitledBorder("Median"));
            this.medianPanel.setLayout(null);
            this.kwTest = new JCheckBox();
            this.medianPanel.add(this.kwTest);
            this.kwTest.setText("Kruskal-Wallis");
            this.kwTest.setBounds(17, 27, 157, 19);
            this.largeAssump2 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.medianPanel.add(this.largeAssump2);
            this.largeAssump2.setBounds(36, 46, 27, 27);
            this.exchAssump = new AssumptionIcon("/icons/eqvar_assump.png", "Exchangablility", null, "Exchangablility");
            this.medianPanel.add(this.exchAssump);
            this.exchAssump.setBounds(63, 46, 27, 27);
            this.median = new JCheckBox();
            this.medianPanel.add(this.median);
            this.median.setText("Median Test");
            this.median.setBounds(17, 85, 157, 19);
            this.largeAssump3 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.medianPanel.add(this.largeAssump3);
            this.largeAssump3.setBounds(36, 105, 27, 27);
            this.sep1 = new JSeparator();
            this.medianPanel.add(this.sep1);
            this.sep1.setBounds(51, 79, 118, 5);
            this.meanPanel = new JPanel();
            this.getContentPane().add((Component)this.meanPanel, new AnchorConstraint(665, 469, 910, 22, 1, 1, 1, 1));
            this.meanPanel.setPreferredSize(new Dimension(245, 144));
            this.meanPanel.setBorder(BorderFactory.createTitledBorder("Mean"));
            this.meanPanel.setLayout(null);
            this.welch = new JCheckBox();
            this.meanPanel.add(this.welch);
            this.welch.setText("One-Way ANOVA (Welch) ");
            this.welch.setBounds(17, 27, 211, 19);
            this.largeAssump = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.meanPanel.add(this.largeAssump);
            this.largeAssump.setBounds(34, 46, 27, 27);
            this.outlierAssump = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", this, "No Outliers");
            this.meanPanel.add(this.outlierAssump);
            this.outlierAssump.setBounds(61, 46, 27, 27);
            this.anova = new JCheckBox();
            this.meanPanel.add(this.anova);
            this.anova.setText("One-Way ANOVA");
            this.anova.setBounds(17, 85, 211, 19);
            this.nOrNormAssump = new AssumptionIcon("/icons/N_or_norm_assump.png", "Large Sample or Normal", this, "Large Sample or Normal");
            this.meanPanel.add(this.nOrNormAssump);
            this.nOrNormAssump.setBounds(34, 105, 47, 27);
            this.outliersAssump2 = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", this, "No Outliers");
            this.meanPanel.add(this.outliersAssump2);
            this.outliersAssump2.setBounds(81, 105, 27, 27);
            this.eqVarAssump = new AssumptionIcon("/icons/eqvar_assump.png", "Equal Variances", null, "Equal Variances");
            this.meanPanel.add(this.eqVarAssump);
            this.eqVarAssump.setBounds(106, 105, 27, 27);
            this.sep = new JSeparator();
            this.meanPanel.add(this.sep);
            this.sep.setBounds(53, 79, 118, 5);
            this.plots = new JButton();
            this.getContentPane().add((Component)this.plots, new AnchorConstraint(565, 303, 737, 4, 1, 0, 0, 2));
            this.plots.setText("Plots");
            this.plots.addActionListener(this);
            this.plots.setPreferredSize(new Dimension(84, 22));
            this.pairwise = new JButton();
            this.getContentPane().add((Component)this.pairwise, new AnchorConstraint(565, 425, 737, 110, 1, 1, 0, 0));
            this.pairwise.setText("Pairwise");
            this.pairwise.addActionListener(this);
            this.pairwise.setPreferredSize(new Dimension(84, 22));
            this.subsetPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.subsetPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.subsetPanel, new AnchorConstraint(480, 979, 638, 570, 1, 1, 1, 1));
            this.subsetPanel.setPreferredSize(new Dimension(224, 93));
            this.subsetPanel.setBorder(BorderFactory.createTitledBorder("Subset"));
            this.subset = new SubsetPanel(this.variableSelector.getJComboBox());
            this.subsetPanel.add((Component)this.subset, "Center");
            this.factorPanel = new JPanel();
            borderLayout = new BorderLayout();
            this.factorPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.factorPanel, new AnchorConstraint(375, 979, 471, 570, 1, 1, 1, 1));
            this.factorPanel.setPreferredSize(new Dimension(224, 57));
            this.factorPanel.setBorder(BorderFactory.createTitledBorder("Factor"));
            this.factor = new SingletonDJList();
            this.factorPanel.add((Component)this.factor, "Center");
            this.factor.setModel(new DefaultListModel());
            this.addFactor = new SingletonAddRemoveButton(new String[]{"Add Factor", "Remove Factor"}, new String[]{"Add Factor", "Remove Factor"}, this.factor, this.variableSelector);
            this.getContentPane().add((Component)this.addFactor, new AnchorConstraint(400, 586, 529, 479, 1, 0, 0, 1));
            this.addFactor.setPreferredSize(new Dimension(34, 34));
            this.outcomePanel = new JPanel();
            borderLayout = new BorderLayout();
            this.outcomePanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.outcomePanel, new AnchorConstraint(12, 13, 375, 570, 2, 2, 1, 1));
            this.outcomePanel.setPreferredSize(new Dimension(223, 208));
            this.outcomePanel.setBorder(BorderFactory.createTitledBorder("Outcomes"));
            this.outcomeScroller = new JScrollPane();
            this.outcomePanel.add((Component)this.outcomeScroller, "Center");
            this.outcomes = new DJList();
            this.outcomeScroller.setViewportView(this.outcomes);
            this.outcomes.setModel(new DefaultListModel());
            this.remove = new RemoveButton("Remove", this.variableSelector, (JList)this.outcomes);
            this.getContentPane().add((Component)this.remove, new AnchorConstraint(199, 570, 304, 479, 1, 0, 0, 1));
            this.remove.setPreferredSize(new Dimension(34, 34));
            this.add = new AddButton("Add", this.variableSelector, (JList)this.outcomes);
            this.getContentPane().add((Component)this.add, new AnchorConstraint(142, 537, 192, 479, 1, 0, 0, 1));
            this.add.setPreferredSize(new Dimension(34, 34));
            this.setTitle("Multiple Independent Samples");
            this.setMinimumSize(new Dimension(359, 300));
            this.setSize(548, 610);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void reset() {
        this.setModel(new KSampleModel());
    }

    public void setModel(KSampleModel kSampleModel) {
        this.factor.setModel(new DefaultListModel());
        this.addFactor.refreshListListener();
        this.outcomes.setModel(new DefaultListModel());
        this.variableSelector.reset();
        if (kSampleModel.dataName != null) {
            this.variableSelector.setSelectedData(kSampleModel.dataName);
            boolean bl = this.variableSelector.removeAll(kSampleModel.variables);
            if (!bl) {
                this.reset();
                return;
            }
            this.outcomes.setModel(kSampleModel.variables);
            bl = this.variableSelector.removeAll(kSampleModel.factorName);
            if (!bl) {
                this.reset();
                this.addFactor.refreshListListener();
                return;
            }
            this.factor.setModel(kSampleModel.factorName);
            this.addFactor.refreshListListener();
            if (kSampleModel.subset == "" || RController.isValidSubsetExp((String)kSampleModel.subset, (String)kSampleModel.dataName)) {
                this.subset.setText(kSampleModel.subset);
            }
        }
        this.model = kSampleModel;
        this.welch.setSelected(this.model.doWelch);
        this.anova.setSelected(this.model.doAnova);
        this.kwTest.setSelected(this.model.doKW);
        this.median.setSelected(this.model.doMedian);
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "Reset") {
            this.setModel(new KSampleModel());
        } else if (string == "Run") {
            this.model.doWelch = this.welch.isSelected();
            this.model.doAnova = this.anova.isSelected();
            this.model.doKW = this.kwTest.isSelected();
            this.model.doMedian = this.median.isSelected();
            this.model.subset = this.subset.getText();
            this.model.variables = (DefaultListModel)this.outcomes.getModel();
            this.model.factorName = (DefaultListModel)this.factor.getModel();
            this.model.dataName = this.variableSelector.getSelectedData();
            boolean bl = this.model.run();
            if (bl) {
                lastModel = this.model;
                SubsetDialog.addToHistory(this.model.dataName, this.model.subset);
                Deducer.setRecentData(this.model.dataName);
                this.dispose();
            }
        } else if (string == "Plots") {
            KSamplePlots kSamplePlots = new KSamplePlots(this, this.model.plots);
            kSamplePlots.setLocationRelativeTo(this);
            kSamplePlots.setVisible(true);
        } else if (string == "comboBoxChanged") {
            this.setModel(new KSampleModel());
        } else if (string == "Pairwise") {
            PairwiseSubDialog pairwiseSubDialog = new PairwiseSubDialog(this);
            pairwiseSubDialog.setLocationRelativeTo(this.pairwise);
            pairwiseSubDialog.setVisible(true);
        }
    }

    class KSampleModel {
        public boolean doWelch = true;
        public boolean doAnova = false;
        public boolean doKW = false;
        public boolean doMedian = false;
        public DefaultListModel variables = new DefaultListModel();
        public DefaultListModel factorName = new DefaultListModel();
        public String subset = "";
        public String dataName = "";
        public OneWayPlotModel plots = new OneWayPlotModel();
        public String pairwiseMethod = "";
        public String pairwiseCorrection = "none";

        KSampleModel() {
        }

        public boolean run() {
            String string;
            if (this.dataName == null) {
                return false;
            }
            if (this.variables.size() == 0) {
                JOptionPane.showMessageDialog(null, "Please select one or more outcome variables.");
                return false;
            }
            if (this.factorName.size() == 0) {
                JOptionPane.showMessageDialog(null, "Please select a factor.");
                return false;
            }
            this.subset = this.subset.trim();
            String string2 = "";
            String string3 = Deducer.makeRCollection(this.variables, "d", false);
            String string4 = (String)this.factorName.get(0);
            if (this.dataName == "") {
                return false;
            }
            boolean bl = false;
            if (!this.subset.equals("")) {
                if (!SubsetDialog.isValidSubsetExp(this.subset, this.dataName)) {
                    JOptionPane.showMessageDialog(null, "Sorry, the subset expression seems to be invalid.");
                    return false;
                }
                string = Deducer.getUniqueName(this.dataName + ".sub");
                string2 = string + "<-subset(" + this.dataName + "," + this.subset + ")\n";
                bl = true;
            } else {
                string = this.dataName;
            }
            if (this.doWelch) {
                string2 = string2 + "k.sample.test(formula=" + string3 + " ~ " + string4 + ",\n\t\tdata=" + string + ",\n\ttest=oneway.test)\n";
            }
            if (this.doAnova) {
                string2 = string2 + "k.sample.test(formula=" + string3 + " ~ " + string4 + ",\n\t\tdata=" + string + ",\n\ttest=oneway.test,var.equal=TRUE)\n";
            }
            if (this.doKW) {
                string2 = string2 + "k.sample.test(formula=" + string3 + " ~ " + string4 + ",\n\t\tdata=" + string + ",\n\ttest=kruskal.test)\n";
            }
            if (this.pairwiseMethod == "t-test (welch)") {
                for (int i = 0; i < this.variables.size(); ++i) {
                    string2 = string2 + "pairwise.t.test(" + string + "$" + this.variables.get(i).toString() + "," + string + "$" + string4 + ", p.adjust.method = '" + ((KSampleDialog)KSampleDialog.this).model.pairwiseCorrection + "')\n";
                }
            } else if (this.pairwiseMethod == "t-test (equal variance)") {
                for (int i = 0; i < this.variables.size(); ++i) {
                    string2 = string2 + "pairwise.t.test(" + string + "$" + this.variables.get(i).toString() + "," + string + "$" + string4 + ", pool.sd = TRUE, p.adjust.method = '" + ((KSampleDialog)KSampleDialog.this).model.pairwiseCorrection + "')\n";
                }
            } else if (this.pairwiseMethod == "wilcoxon") {
                for (int i = 0; i < this.variables.size(); ++i) {
                    string2 = string2 + "pairwise.wilcox.test(" + string + "$" + this.variables.get(i).toString() + "," + string + "$" + string4 + ", p.adjust.method = '" + ((KSampleDialog)KSampleDialog.this).model.pairwiseCorrection + "')\n";
                }
            }
            string2 = string2 + ((KSampleDialog)KSampleDialog.this).model.plots.getCmd(string, string3, string4);
            if (bl) {
                string2 = string2 + "rm(" + string + ")\n";
            }
            Deducer.execute(string2);
            return true;
        }
    }

    class PairwiseSubDialog
    extends JDialog {
        private JComboBox correction;
        private JLabel label1;
        private OkayCancelPanel okayCancel;
        private JComboBox method;
        private JLabel label2;

        public PairwiseSubDialog(JDialog jDialog) {
            super(jDialog);
            this.initGUI();
            this.method.setSelectedItem(((KSampleDialog)KSampleDialog.this).model.pairwiseMethod);
            this.correction.setSelectedItem(((KSampleDialog)KSampleDialog.this).model.pairwiseCorrection);
        }

        private void initGUI() {
            try {
                this.getContentPane().setLayout(null);
                Object object = new DefaultComboBoxModel<String>(new String[]{"holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"});
                this.correction = new JComboBox();
                this.getContentPane().add(this.correction);
                this.correction.setModel(object);
                this.correction.setBounds(113, 66, 113, 22);
                this.label1 = new JLabel();
                this.getContentPane().add(this.label1);
                this.label1.setText("Correction:");
                this.label1.setBounds(12, 70, 89, 15);
                this.label1.setHorizontalAlignment(11);
                this.label2 = new JLabel();
                this.getContentPane().add(this.label2);
                this.label2.setText("Method:");
                this.label2.setBounds(24, 32, 77, 15);
                this.label2.setHorizontalAlignment(11);
                object = new DefaultComboBoxModel<String>(new String[]{"", "t-test (welch)", "t-test (equal variance)", "wilcoxon"});
                this.method = new JComboBox();
                this.getContentPane().add(this.method);
                this.method.setModel(object);
                this.method.setBounds(113, 28, 113, 22);
                object = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand() == "OK") {
                            ((KSampleDialog)KSampleDialog.this).model.pairwiseMethod = (String)PairwiseSubDialog.this.method.getSelectedItem();
                            ((KSampleDialog)KSampleDialog.this).model.pairwiseCorrection = (String)PairwiseSubDialog.this.correction.getSelectedItem();
                        }
                        PairwiseSubDialog.this.dispose();
                    }
                };
                this.okayCancel = new OkayCancelPanel(false, false, (ActionListener)object);
                this.getContentPane().add(this.okayCancel);
                this.okayCancel.setBounds(64, 100, 162, 34);
                this.setModal(true);
                this.setSize(249, 168);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

