% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\title{Empirical AM and FM decomposition}
\usage{
normalise(emd = NULL, m = NULL, dt = NULL, repl = 1, last = TRUE, speak = TRUE)
}
\arguments{
\item{emd}{an emd object}

\item{m}{a matrix of the modes to calculate the amplitude and the frequency
carrier from. Is overridden by emd.}

\item{dt}{the depth or time. Is overridden by emd.}

\item{repl}{the amount of replicates in m. Is overridden by emd.}

\item{last}{whether to use the last mode (trend/residue).}

\item{speak}{whether to print a sentence at each iteration}
}
\value{
a list of two matrices: $fc (frequency carrier) and $a (instantaneous
amplitude)
}
\description{
Applies the normalisation scheme of Huang et al., 2009 to
decompose any Intrinsic Mode Functions obtained (usually via Empirical Mode
Decomposition) into an Frequency Modulated component of amplitude 1, also
called carrier, and its Amplitude Modulated enveloppe. The carrier can then
be used to compute the instantaneous frequency via the Normalised Hilbert
Transform (NHT) or by calculating its Direct Quadrature (DQ) (Huang et al.,
2009). HOWEVER THIS FUNCTION CAN FAIL due to overshoot or undershoot of the
spline fitting. Additional research is necessary.
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
        rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7,
               repl = 1, comb = 100, factor_noise = 10,
               speak = TRUE)

plot_emd(dec, pdf = FALSE, select = 4)

integrity(xy, dec)
parsimony(dec)

m  <- dec$m

res <- normalise(dt = dt, m = m, last = FALSE)

numb <- 4

opar <- par('mfrow')

par(mfrow = c(1,2))

plot(m[,numb], dt, type = "l", xlab = "xy",
     main = paste("Mode", numb, "and AM enveloppe"))
lines(res$a[,numb], dt, col = "red", lty = 5, lwd = 2)

plot(res$fc[,numb], dt, type = "l", xlab = "xy",
     main = "FM carrier")

par(mfrow = opar)

}
\references{
Huang, Norden E., Zhaohua Wu, Steven R. Long, Kenneth C. Arnold,
Xianyao Chen, and Karin Blank. 2009. ‘On Instantaneous Frequency’. Advances
in Adaptive Data Analysis 01 (02): 177–229.
https://doi.org/10.1142/S1793536909000096.
}
