% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq.algorithm.R
\name{dq.algorithm}
\alias{dq.algorithm}
\title{Calculates instantaneous frequency of freqeuncy carriers using the DQ
method}
\usage{
dq.algorithm(fc, dt)
}
\arguments{
\item{fc}{a matrix of amplitude between -1 and 1, making up the frequency
carrier}

\item{dt}{a vector of depth or time values}
}
\value{
a list of the depth/time (dt), frequency (f), and identity tuning
(idt), i.e. depths adapted to transform the frequency carrier into a cosine
of period 1.
}
\description{
Calculates instantaneous frequency of frequency carriers using
the direct quadrature method from Huang et al., 2009.
}
\examples{
n <- 600

t <- seq_len(n)

p1 <- 30

xy <- sin(t*2*pi/p1 + 50)

int <- c(rep(1, 99 + 100), seq(1,3,2/100), seq(3,1,-2/100), rep(1,100 + 99))

dt <- cumsum(int)

cond <- dt < 75

xy <- xy[!cond]
dt <- dt[!cond]/1.2 - 62.5

res <- dq.algorithm(xy, dt)

opar <- par("mfrow")

par(mfrow = c(3,1))

plot(dt, xy, type = "o", pch = 19, main = "Frequency carrier")

plot(dt, 1/res$f, pch = 19, type = "l", log = "y", lwd = 2, ylim = c(25,80),
     main = "Period (Direct Quadrature method)", ylab = "Period")

plot(res$idt[,1], xy, type = "o", pch = 19,
     main = "Identity tuning", axes = FALSE, ylab = "xy", xlab = "dt")

ap <- approx(x = dt, y = res$idt[,1], xout = seq(0,600, by = 20))

axis(1, at = ap$y, labels = ap$x)
axis(2)
box()

par(mfrow = opar)

}
\references{
Huang, Norden E., Zhaohua Wu, Steven R. Long, Kenneth C. Arnold,
Xianyao Chen, and Karin Blank. 2009. "On Instantaneous Frequency". Advances
in Adaptive Data Analysis 01 (02): 177–229.
https://doi.org/10.1142/S1793536909000096.
}
