/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.cmdlineverification;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.starschema.clouddb.cmdlineverification.VerificationCodeReceiver;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

public final class LocalServerReceiver
implements VerificationCodeReceiver {
    private static final String CALLBACK_PATH = "/Callback";
    private Server server;
    volatile String code;

    private static int getUnusedPort() throws IOException {
        s.bind(null);
        try (Socket s = new Socket();){
            int n = s.getLocalPort();
            return n;
        }
    }

    @Override
    public String getRedirectUri() throws Exception {
        int port = LocalServerReceiver.getUnusedPort();
        this.server = new Server(port);
        for (Connector c : this.server.getConnectors()) {
            c.setHost("localhost");
        }
        this.server.addHandler((Handler)new CallbackHandler());
        this.server.start();
        return "http://localhost:" + port + CALLBACK_PATH;
    }

    @Override
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    @Override
    public synchronized String waitForCode() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.code;
    }

    class CallbackHandler
    extends AbstractHandler {
        CallbackHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
            if (!LocalServerReceiver.CALLBACK_PATH.equals(target)) {
                return;
            }
            this.writeLandingHtml(response);
            response.flushBuffer();
            ((Request)request).setHandled(true);
            String error = request.getParameter("error");
            if (error != null) {
                System.out.println("Authorization failed. Error=" + error);
                System.out.println("Quitting.");
                System.exit(1);
            }
            LocalServerReceiver.this.code = request.getParameter("code");
            LocalServerReceiver localServerReceiver = LocalServerReceiver.this;
            synchronized (localServerReceiver) {
                LocalServerReceiver.this.notify();
            }
        }

        private void writeLandingHtml(HttpServletResponse response) throws IOException {
            response.setStatus(200);
            response.setContentType("text/html");
            PrintWriter doc = response.getWriter();
            doc.println("<html>");
            doc.println("<head><title>OAuth 2.0 Authentication Token Recieved</title></head>");
            doc.println("<body>");
            doc.println("Received verification code. Closing...");
            doc.println("<script type='text/javascript'>");
            doc.println("window.setTimeout(function() {");
            doc.println("    window.open('', '_self', ''); window.close(); }, 1000);");
            doc.println("if (window.opener) { window.opener.checkToken(); }");
            doc.println("</script>");
            doc.println("</body>");
            doc.println("</HTML>");
            doc.flush();
        }
    }
}

