% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Andromeda.R
\name{lowLevelQuerySqlToAndromeda}
\alias{lowLevelQuerySqlToAndromeda}
\title{Low level function for retrieving data to a local Andromeda database}
\usage{
lowLevelQuerySqlToAndromeda(
  connection,
  query,
  andromeda,
  andromedaTableName,
  datesAsString = FALSE
)
}
\arguments{
\item{connection}{The connection to the database server.}

\item{query}{The SQL statement to retrieve the data}

\item{andromeda}{An open connection to a Andromeda database, for example as created using \code{\link[Andromeda]{andromeda}}.}

\item{andromedaTableName}{The name of the table in the local Andromeda database where the results of the query will be stored.}

\item{datesAsString}{Should dates be imported as character vectors, our should they be converted
to R's date format?}
}
\value{
Invisibly returns the andromeda. The Andromeda database will have a table added with the query results.
}
\description{
This is the equivalent of the \code{\link{querySqlToAndromeda}} function, except no error report is
written when an error occurs.
}
\details{
Retrieves data from the database server and stores it in a local Andromeda database This allows very large
data sets to be retrieved without running out of memory. Null values in the database are converted
to NA values in R. If a table with the same name already exists in the local Andromeda database it is replaced.
}
