% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbHasCompleted,DatabaseConnectorResult-method}
\alias{dbHasCompleted,DatabaseConnectorResult-method}
\title{Completion status}
\usage{
\S4method{dbHasCompleted}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbHasCompleted()} returns a logical scalar.
For a query initiated by \code{\link[=dbSendQuery]{dbSendQuery()}} with non-empty result set,
\code{dbHasCompleted()} returns \code{FALSE} initially
and \code{TRUE} after calling \code{\link[=dbFetch]{dbFetch()}} without limit.
For a query initiated by \code{\link[=dbSendStatement]{dbSendStatement()}},
\code{dbHasCompleted()} always returns \code{TRUE}.
Attempting to query completion status for a result set cleared with
\code{\link[=dbClearResult]{dbClearResult()}} gives an error.
}
\description{
This method returns if the operation has completed.
A \code{SELECT} query is completed if all rows have been fetched.
A data manipulation statement is always completed.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbHasCompleted")}
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
