
#' dt.round.numerics
#'
#' @description rounds the number to desired decimal digits
#'
#' @param dt.name a character value specifying the name of a data.frame or data.table object.

#' @param digits  the number of digits to round to.  This number will be exact, in that there will be exactly k decimal places listed even if this includes lagging zeros.  For instance, setting k = 5 for x = 2.54 would result in 2.54000

#' @param the.variables a character vector specifying the variables that we want to apply a function to.  Only values that exist in names(dat) will be used; other values in the.variables will be excluded from the calculation.  When the.variables includes ".", then all values in names(dat) will be selected.  Values of the.variables that also exist in grouping.variables will be excluded from the.variables (but grouped by these values).

#' @param the.filter a character value, logical value, or expression stating the logical operations to be performed in filtering the data prior to calculating the.function.

#' @param grouping.variables  a character vector specifying variables to group by in performing the computation.  Only values that exist in names(dat) will be used.

#' @param envir the environment in which the code would be evaluated; parent.frame() by default.
#'
#' @param  ... additional arguments to be passed
#'

#' @param add.function.name  a logical value specifying whether the name of the function applied should be appended to the column names in the resulting table.
#' @param sortby.group a logical value to specify if the sorting functionality needs to be applied or not
#'
#'
#' @param return.as describes whether return should be result, code or mixture of both
#' @return The function's output varies based on the 'return.as' parameter:
#' - If 'return.as' is "result", it returns the input data frame or data table with specified numeric variables rounded to the defined number of decimal places. The rounding is applied even if it results in trailing zeros, ensuring a consistent number of decimal places across the data.
#' - If 'return.as' is "code", the function provides the R code or expressions designed to perform this rounding, allowing users to examine or execute the rounding logic independently.
#' - If another option is specified for 'return.as', the output may include both the rounded data and the corresponding R code, varying with the function’s setup.
#'
#' The function is crafted to modify numerical data by rounding it to a specified number of decimal places, aiding in data standardization and precision control, especially beneficial for detailed numerical analysis or reporting.

#' @export

dt.round.numerics <- function(dt.name, digits, the.variables = ".", the.filter = NULL,
                              grouping.variables = NULL, sortby.group = TRUE,
                              add.function.name = FALSE, return.as = "result",
                              envir = parent.frame(), ...){

  other.params <- sprintf("digits = %d", floor(digits))

  return(dt.calculate(dt.name = dt.name, the.variables = the.variables,
                      the.functions = "round.numerics", the.filter = the.filter,
                      grouping.variables = grouping.variables, sortby.group = sortby.group,
                      other.params = other.params, table.format = "wide",
                      add.function.name = add.function.name, return.as = return.as, envir = envir))
}
