% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{cols.DTSg}
\alias{cols.DTSg}
\alias{cols}
\title{Get Column Names}
\usage{
\method{cols}{DTSg}(x, class = NULL, pattern = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{class}{An optional character vector matched to the most specific class
(first element) of each column's \code{\link{class}} vector.}

\item{pattern}{An optional character string passed on to the \code{pattern}
argument of \code{\link{grep}}.}

\item{\dots}{Further arguments passed on to \code{\link{grep}}. The
\code{value} argument is rejected.}
}
\value{
Returns a character vector.
}
\description{
Queries all column names of a \code{\link{DTSg}} object, those of certain
 \code{\link{class}}es and/or those matching a certain pattern only.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# get names of numeric columns
## R6 method
x$cols(class = "numeric")

## S3 method
cols(x = x, class = "numeric")

}
\seealso{
\code{\link{DTSg}}, \code{\link{class}}, \code{\link{grep}}
}
