% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.curve.R
\name{ds.curve}
\alias{ds.curve}
\title{Extract the dose-survival curve, with its upper and lower confidence band
limits}
\usage{
ds.curve(de, ...)
}
\arguments{
\item{de}{A data frame describing a dose-titration study.}

\item{\dots}{Passed through to function \code{dose.survfit}}
}
\value{
A list with components \code{surv}, \code{upper} and \code{lower},
each containing a vector that can be indexed by dose level.
}
\description{
This utility function simply makes the results of \code{dose.survfit}
available in the convenient form of a list.
}
\examples{
CV <- 0.7; mean_mtd <- 1.0
shape <- CV^-2; scale <- mean_mtd/shape
trial <- new("DE", doses=0.25 * 1.4^(0:6),
             MTDi=rgamma(24, shape=shape, scale=scale),
             units="mg")
trial <- titration(trial, periods=10)
ds.curve(trial@data)

}
\seealso{
\code{\link{dose.survfit}}
}
\author{
David C. Norris
}
\keyword{survival}
