% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\docType{class}
\name{DSConnection-class}
\alias{DSConnection-class}
\title{DSConnection class}
\description{
This virtual class encapsulates the connection to a DataSHIELD-aware data repository,
and it provides access to data assignments and aggregagtions etc.
}
\section{Implementation note}{

Individual drivers are free to implement single or multiple simultaneous
connections.
}

\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1", 
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
con
dsDisconnect(con)
}
}
\seealso{
Other DS classes: 
\code{\link{DSDriver-class}},
\code{\link{DSObject-class}},
\code{\link{DSResult-class}}

Other DSConnection generics: 
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRestoreWorkspace}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DS classes}
\concept{DSConnection generics}
