% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.connections.R
\name{datashield.connections_default}
\alias{datashield.connections_default}
\title{Set or get the default list of DSConnection objects in the analytic environment}
\usage{
datashield.connections_default(
  name = NULL,
  env = getOption("datashield.env", globalenv())
)
}
\arguments{
\item{name}{Symbol name that identifies the set of \code{\link{DSConnection-class}} objects to be used by default. If not provided,
the 'default.connections' variable value is returned.}

\item{env}{The environment where to search for the connection symbols. Try to get it from the
'datashield.env' option, with default to the Global Environment.}
}
\value{
The 'default.connections' value from the analytic environment or NULL if the 'default.connections' symbol is not defined.
}
\description{
By default if there is only one set of \code{\link{DSConnection-class}} objects that is available for
analysis, all DataSHIELD client-side functions will use that full set of DSConnections unless
the 'datasources=' argument has been set and specifies that a particular subset of those
DSConnections should be used instead. The correct identification of the full
single set of opals is based on the \link{datashield.connections_find} function.
To illustrate, if the single set of Opals is called 'study.opals' and consists of
six servers numbered studies[1] to studies[6] then all client-side functions will
use data from all six of these 'studies' unless, say, datasources=studies[c(2,5)] is
declared and only data from the second and fifth studies will then be used.
On the other hand, if there is more than one set of DSConnections in the analytic environment
client-side functions will be unable to determine which set to use. The function \link{datashield.connections_find}
has therefore been written so that if one of the DSConnection sets is called 'default.connections'
then that set - i.e. 'default.connections' - will be selected by default by all DataSHIELD
client-side functions. If there is more than one set of DSConnections in the analytic environment
and NONE of these is called 'default.connections', the function \link{datashield.connections_find} will fail.
Therefore datashield.connections_default copies the provided set of DSConnections as 'default.connections'.
This set will then be selected by default by all client-side functions, unless it is deleted and
an alternative set of DSConnections is copied and named 'default.connections'. Regardless
how many sets of DSConnections exist and regardless whether any of them may be called 'default.connections',
the 'datasources=' argument overrides the defaults and allows the user to base his/her analysis
on any set of DSConnections and any subset of those DSConnections.
}
\seealso{
Other Connections management: 
\code{\link{datashield.connections_find}()},
\code{\link{datashield.connections}()}
}
\concept{Connections management}
