% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{dmcFitSubject}
\alias{dmcFitSubject}
\title{dmcFitSubject}
\usage{
dmcFitSubject(
  resOb,
  nTrl = 1e+05,
  startVals = list(),
  minVals = list(),
  maxVals = list(),
  fixedFit = list(),
  fitInitialGrid = TRUE,
  fitInitialGridN = 10,
  fixedGrid = list(),
  nCAF = 5,
  nDelta = 19,
  pDelta = vector(),
  tDelta = 1,
  costFunction = "RMSE",
  spDist = 1,
  drDist = 0,
  drShape = 3,
  drLim = c(0.1, 0.7),
  rtMax = 5000,
  subjects = c(),
  printInputArgs = TRUE,
  printResults = FALSE,
  optimControl = list(),
  numCores = 2
)
}
\arguments{
\item{resOb}{Observed data (see flankerData and simonTask for data format) and the function dmcObservedData to create
the required input from either an R data frame or external *.txt/*.csv files}

\item{nTrl}{Number of trials to use within dmcSim.}

\item{startVals}{Starting values for to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., startVals = list(amp = 20, tau = 200,
drc = 0.5, bnds = 75, resMean = 300, resSD = 30, aaShape = 2, spShape = 3, spBias = 0, sigm = 4)).}

\item{minVals}{Minimum values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., minVals = list(amp = 10, tau = 5, drc = 0.1,
bnds = 20, resMean = 200, resSD = 5, aaShape = 1, spShape = 2, spBias = -20, sigm = 1)).}

\item{maxVals}{Maximum values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., maxVals = list(amp = 40, tau = 300, drc = 1.0,
bnds = 150, resMean = 800, resSD = 100, aaShape = 3, spShape = 4, spBias = 20, sigm = 10))}

\item{fixedFit}{Fix parameter to starting value. This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., fixedFit = list(amp = F, tau = F, drc = F,
bnds = F, resMean = F, resSD = F, aaShape = F, spShape = F, spBias = T, sigm = T))}

\item{fitInitialGrid}{TRUE/FALSE}

\item{fitInitialGridN}{10 linear steps between parameters min/max values (reduce if searching more than ~2/3 initial parameters)}

\item{fixedGrid}{Fix parameter for initial grid search. This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., fixedGrid = list(amp = T, tau = F, drc = T,
bnds = T, resMean = T, resSD = T, aaShape = T, spShape = T, spBias = T, sigm = T)). As a default, the initial gridsearch
only searches the tau space.}

\item{nCAF}{Number of CAF bins.}

\item{nDelta}{Number of delta bins.}

\item{pDelta}{An alternative option to nDelta by directly specifying required percentile values (vector of values 0-100)}

\item{tDelta}{The type of delta calculation (1=direct percentiles points, 2=percentile bounds (tile) averaging)}

\item{costFunction}{The cost function to minimise: root mean square error ("RMSE": default),
squared percentage error ("SPE"), or likelihood-ratio chi-square statistic ("GS")}

\item{spDist}{The starting point (sp) distribution (0 = constant, 1 = beta, 2 = uniform)}

\item{drDist}{The drift rate (dr) distribution type (0 = constant, 1 = beta, 2 = uniform)}

\item{drShape}{The drift rate (dr) shape parameter}

\item{drLim}{The drift rate (dr) range}

\item{rtMax}{The limit on simulated RT (decision + non-decisional components)}

\item{subjects}{NULL (aggregated data across all subjects) or integer for subject number}

\item{printInputArgs}{TRUE (default) /FALSE}

\item{printResults}{TRUE/FALSE (default)}

\item{optimControl}{Additional control parameters passed to optim (see optim details section)}

\item{numCores}{Number of cores to use}
}
\value{
dmcFitSubject returns a list of objects of class "dmcfit"
}
\description{
Fit theoretical data generated from dmcSim to observed data by
minimizing the root-mean-square error ("RMSE") between a weighted combination
of the CAF and CDF functions using optim (Nelder-Mead). Alternative cost functions
include squared percentage error ("SPE"), and g-squared statistic ("GS").
}
\examples{
\donttest{
# Code below can exceed CRAN check time limit, hence donttest
# Example 1: Flanker data from Ulrich et al. (2015)
fit <- dmcFitSubject(flankerData, nTrl = 1000, subjects = c(1, 2));
plot(fit, flankerData, subject = 1)
plot(fit, flankerData, subject = 2)
summary(fit)

# Example 2: Simon data from Ulrich et al. (2015)
fit <- dmcFitSubject(simonData, nTrl = 1000, subject = c(1, 2))
plot(fit, simonData, subject = 1)
plot(fit, simonData, subject = 2)
summary(fit)
}

}
