% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmcsim}
\alias{plot.dmcsim}
\title{plot.dmcsim}
\usage{
\method{plot}{dmcsim}(
  x,
  figType = "summary1",
  ylimCAF = c(0, 1),
  cafBinLabels = FALSE,
  ylimDelta = c(-50, 150),
  ylimRt = c(200, 800),
  ylimErr = c(0, 20),
  legend = TRUE,
  labels = c("Compatible", "Incompatible"),
  cols = c("black", "green", "red"),
  errorBars = FALSE,
  xlabs = TRUE,
  ylabs = TRUE,
  xaxts = TRUE,
  yaxts = TRUE,
  resetPar = TRUE,
  ...
)
}
\arguments{
\item{x}{Output from dmcSim}

\item{figType}{summary1, summary2, summary3, activation, trials, pdf, cdf, caf, delta, rtCorrect, rtErrors, errorRate, all}

\item{ylimCAF}{ylimit for CAF plot}

\item{cafBinLabels}{TRUE/FALSE}

\item{ylimDelta}{ylimit for delta plot}

\item{ylimRt}{ylimit for rt plot}

\item{ylimErr}{ylimit for er plot}

\item{legend}{TRUE/FALSE (or FUNCTION) plot legend on each plot}

\item{labels}{Condition labels c("Compatible", "Incompatible") default}

\item{cols}{Condition colours c("green", "red") default}

\item{errorBars}{TRUE/FALSE}

\item{xlabs}{TRUE/FALSE}

\item{ylabs}{TRUE/FALSE}

\item{xaxts}{TRUE/FALSE}

\item{yaxts}{TRUE/FALSE}

\item{resetPar}{TRUE/FALSE Reset graphical parameters}

\item{...}{additional plot pars}
}
\description{
Plot the simulation results from the output of dmcSim. The plot
can be an overall summary, or individual plots (activation, trials, pdf, cdf,
caf, delta, all). Plot type summary1 contains an activation plot, example
individual trials, the probability distribution function (PDF), the cumulative
distribution function (CDF), the conditional accuracy function (CAF) and
delta plot. This requires that dmcSim is run with fullData = TRUE. Plot type
summary2 contains only the PDF, CDF, CAF and delta plots and does not require
that dmcSim is run with fullData = TRUE.
}
\examples{
\donttest{
# Example 1
dmc = dmcSim(fullData = TRUE)
plot(dmc)

# Example 2
dmc = dmcSim()
plot(dmc)

# Example 3
dmc = dmcSim()
plot(dmc, figType = "all")

# Example 4
dmc = dmcSim()
plot(dmc, figType = "summary3")
}

}
