% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{calculateCAF}
\alias{calculateCAF}
\title{calculateCAF}
\usage{
calculateCAF(
  dat,
  stepCAF = 20,
  columns = c("VP", "Comp", "RT", "Error"),
  compCoding = c("comp", "incomp"),
  errorCoding = c(0, 1)
)
}
\arguments{
\item{dat}{DataFrame with columns containing the participant number, condition
compatibility, RT data (in ms) and an Error column.}

\item{stepCAF}{Step size for the CAF bins. For example, a step size of 20 would
result in 5 CAF bins centered on 10, 30, 50, 70, and 90\%.}

\item{columns}{Name of required columns Default: c("VP", "Comp", "RT", "Error")}

\item{compCoding}{Coding for compatibility Default: c("comp", "incomp")}

\item{errorCoding}{Coding for errors Default: c(0, 1))}
}
\value{
DataFrame (tibble)
}
\description{
Calculate conditional accuracy function (CAF).
The DataFrame should contain columns defining the participant, compatibility condition,
RT and error (Default column names: "VP", "Comp", "RT", "Error"). The "Comp" column should
define compatibility condition (Default: c("comp", "incomp")) and the "Error" column should
define if the trial was an error or not (Default: c(0, 1) ).
}
\examples{
# Example 1
dat <- createDF(nVP = 1, nTrl = 100, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"   = c(500, 80, 100),
                           "Comp_incomp" = c(600, 80, 140)),
                 Error = list("Comp_comp"   = c(5, 4,3,2,1),
                              "Comp_incomp" = c(20, 8, 6, 4, 2)))
caf <- calculateCAF(dat)

# Example 2
dat <- createDF(nVP = 1, nTrl = 100, design = list("Congruency" = c("cong", "incong")))
dat <- addDataDF(dat,
                 RT = list("Congruency_cong"   = c(500, 80, 100),
                           "Congruency_incong" = c(600, 80, 140)),
                 Error = list("Congruency_cong"   = c(5, 4,3,2,1),
                              "Congruency_incong" = c(20, 8, 6, 4, 2)))
head(dat)
caf <- calculateCAF(dat, columns = c("VP", "Congruency", "RT", "Error"),
                    compCoding = c("cong", "incong"))

}
