% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_Functions.R
\name{DataInit}
\alias{DataInit}
\title{Initialize Data Input Files}
\usage{
DataInit(name = "Data", ext = c("xlsx", "csv"), overwrite = FALSE, dir = NULL)
}
\arguments{
\item{name}{Name of the data input files. Default is 'Data'. Use 'Example'
to create populated example Data Input and Data Documenation files.}

\item{ext}{Optional file extension for input file. 'xlsx' (default) or 'csv'}

\item{overwrite}{Logical. Overwrite existing files?}

\item{dir}{Optional directory path to create the Data files. Default is `getwd()``}
}
\value{
Nothing. Creates template data files in the working directory.
}
\description{
Creates template for the Data input file (Excel or CSV) and Data documentation file (Markdown)
in the working directory or the directory specified by the \code{dir} argument
}
\examples{
\dontrun{
DataInit("Example") # populated example
DataInit("myData") # empty template
}
}
\author{
A. Hordyk
}
