% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSCAM2DLM.R
\name{iSCAM2DLM}
\alias{iSCAM2DLM}
\title{Reads MLE estimates from iSCAM file structure into an operating model}
\usage{
iSCAM2DLM(iSCAMdir, nsim = 48, proyears = 50, mcmc = F, Name = NULL,
  Source = "No source provided", length_timestep = 1,
  Author = "No author provided")
}
\arguments{
\item{iSCAMdir}{A folder with iSCAM input and output files in it}

\item{nsim}{The number of simulations to take for parameters with
uncertainty (for OM@cpars custom parameters)}

\item{proyears}{The number of MSE projection years}

\item{mcmc}{Whether to use mcmc samples to create custom parameters cpars}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{length_timestep}{How long is a model time step in years
(e.g. a quarterly model is 0.25, a monthly model 1/12)}

\item{Author}{Who did the assessment}
}
\description{
A function that uses the file location of a fitted iSCAM
model including input files to population the various slots of an
operating model parameter estimates. iSCAM2DLM relies on several
functions written by Chris Grandin (DFO PBS).
}
\author{
T. Carruthers
}
