% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste2.R
\name{paste2}
\alias{paste2}
\title{Normal `paste` function with additional `collapse_last` argument.}
\usage{
paste2(..., collapse = NULL, collapse_last = NULL, sep = " ", recycle0 = FALSE)
}
\arguments{
\item{...}{one or more \R objects, to be converted to character vectors.}

\item{collapse}{an optional character string to separate the results.  Not
    \code{\link[base]{NA_character_}}.}

\item{collapse_last}{(string, optional) The string to use for the last
instance while collapsing. All other elements will be pasted using
the normal `collapse` argument. If `collapse` is not set, `collapse_last`
will be ignored.}

\item{sep}{a character string to separate the terms.  Not
    \code{\link[base]{NA_character_}}.}

\item{recycle0}{\code{\link[base]{logical}} indicating if zero-length
    character arguments should lead to the zero-length
    \code{\link[base]{character}(0)} after the \code{sep}-phase (which turns into
    \code{""} in the \code{collapse}-phase, i.e., when \code{collapse} is
    not \code{NULL}).}
}
\value{
String. See`?paste` for details.
}
\description{
The base `paste` function but with the add on to also supply a
  `collapse_last` value to change the `collapse` argument at the last
  position. To get from "cat", "mouse", "dog" to a string
  "cat, mouse and dog", one simply needs to call
  `paste(c("cat","mouse","dog"), collapse = ", ", collapse_last = " and ")`
}
\examples{
{
  paste2(c("cat", "mouse", "dog"),
         collapse = ", ",
         collapse_last = " and ")
  #> [1] "cat, mouse and dog"
}
}
\references{
\url{https://stackoverflow.com/a/38276239}
}
