% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.DIFtree.R
\name{plot.DIFtree}
\alias{plot.DIFtree}
\title{Plotting of Item focussed Trees}
\usage{
\method{plot}{DIFtree}(x, item, component = "intercept", cex.lines = 2,
  cex.branches = 1, cex.coefs = 1, cex.main = 1, title = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{\link[DIFtree]{DIFtree}}}

\item{item}{Number of the item, for which the tree shall be plotted}

\item{component}{Component of the model for which the tree shall be plotted; 
can be \code{"intercept"} or \code{"slope"}. For \code{"Rasch"} model only one tree of item difficulties 
is available for each DIF item and therefore \code{component} will be ignored.}

\item{cex.lines}{Width of branches of the tree}

\item{cex.branches}{Size of the labels of branches of the tree}

\item{cex.coefs}{Size of coefficients given in the terminal nodes of the tree}

\item{cex.main}{Size of the title of the tree}

\item{title}{Optional title, which is added to the tree;
if \code{title=NULL} the title is the number of the plotted item.}

\item{...}{Further arguments passed to or from other methods}
}
\description{
Visualization of trees for items with DIF identified by item focussed recursive partitioning 
based on the Rasch Model or the Logistic Regression Approach for DIF detection.
}
\examples{
data(data_sim)
 
Y <- data_sim[,1]
X <- data_sim[,-1]
 
\dontrun{
 
mod <- DIFtree(Y=Y,X=X,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
 
plot(mod,item=1)
}
}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Berger, Moritz and Tutz, Gerhard (2015): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Cornell University Library, arXiv:1511.07178

Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Psychometrika, published online, DOI: 10.1007/s11336-015-9488-3
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}, \code{\link[DIFtree]{summary.DIFtree}}
}

