% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResiduals.R
\name{plotResiduals}
\alias{plotResiduals}
\title{Generic residual plot with either spline or quantile regression}
\usage{
plotResiduals(pred, residuals = NULL, quantreg = NULL, rank = FALSE,
  asFactor = FALSE, ...)
}
\arguments{
\item{pred}{either the predictor variable against which the residuals should be plotted, or a DHARMa object}

\item{residuals}{residuals values. Leave empty if pred is a DHARMa object}

\item{quantreg}{whether to perform a quantile regression on 0.25, 0.5, 0.75 on the residuals. If F, a spline will be created instead. Default NULL chooses T for nObs < 2000, and F otherwise.}

\item{rank}{if T, the values of pred will be rank transformed. This will usually make patterns easier to spot visually, especially if the distribution of the predictor is skewed. If pred is a factor, this has no effect.}

\item{asFactor}{should the predictor variable converted into a factor}

\item{...}{additional arguments to plot}
}
\description{
The function creates a generic residual plot with either spline or quantile regression
}
\details{
For a correctly specified model, we would expect uniformity in y direction when plotting against any predictor.

To provide a visual aid in detecting deviations from uniformity in y-direction, the plot of the residuals against the predited values also performs an (optional) quantile regression, which provides 0.25, 0.5 and 0.75 quantile lines across the plots. These lines should be straight, horizontal, and at y-values of 0.25, 0.5 and 0.75. Note, however, that some deviations from this are to be expected by chance, even for a perfect model, especially if the sample size is small.

The quantile regression can take some time to calculate, especially for larger datasets. For that reason, quantreg = F can be set to produce a smooth spline instead.
}
\note{
if pred is a factor, a boxplot will be plotted instead of a scatter plot. The distribution for each factor level should be uniformly distributed, so the box should go from 0.25 to 0.75, with the median line at 0.5. Again, chance deviations from this will increases when the sample size is smaller. You can run null simulations to test if the deviations you see exceed what you would expect from random variation. If you want to create box plots for categorical predictors (e.g. because you only have a small number of unique numberic predictor values), you can convert your predictor with as.factor(pred)
}
\examples{
testData = createData(sampleSize = 200, family = poisson(), 
                      randomEffectVariance = 0, numGroups = 5)
fittedModel <- glm(observedResponse ~ Environment1, 
                   family = "poisson", data = testData)
simulationOutput <- simulateResiduals(fittedModel = fittedModel)

######### main plotting function #############

# for all functions, quantreg = T will be more
# informative, but slower

plot(simulationOutput, quantreg = FALSE)

#############  qq plot  ######################

plotQQunif(simulationOutput = simulationOutput)

#############  residual plots  ###############

# rank transformation, using a simulationOutput
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE)

# residual vs predictors, using explicit values for pred, residual 
plotResiduals(pred = testData$Environment1, 
              residuals = simulationOutput$scaledResiduals, quantreg = FALSE)

# if pred is a factor, or asFactor = T, will produce a boxplot
plotResiduals(pred = testData$group, residuals = simulationOutput$scaledResiduals, 
              quantreg = FALSE, asFactor = TRUE)

# All these options can also be provided to the main plotting function
plot(simulationOutput, quantreg = FALSE, rank = FALSE)

# If you want to plot summaries per group, use
simulationOutput = recalculateResiduals(simulationOutput, group = testData$group)
plot(simulationOutput, asFactor = TRUE) # we see one residual point per RE


}
\seealso{
\code{\link{plotSimulatedResiduals}}, \code{\link{plotQQunif}}
}
