% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{succession}
\alias{succession}
\title{create a temporal succession}
\usage{
succession(vegetation, stand.id = 1, patch.id = NULL, init.year = 1901,
  years = seq(1950, 2000, 10))
}
\arguments{
\item{vegetation}{data.frame}

\item{stand.id}{the Stand ID}

\item{patch.id}{the patch ID, if NULL all available ones are considered}

\item{init.year}{year, when to initialize the tree positions}

\item{years}{the years to be included}
}
\value{
a stand object
}
\description{
create a temporal succession
}
\examples{
\dontrun{
stand=succession(dgvm3d.succession[[3]], init.year=1865, years=c(1865, seq(1875, 2000, 25)),
                 patch.id=sample(1:12, 3))
stand3D(stand)
stand=plant3D(stand)
}
}
