% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{plot.Weibull}
\alias{plot.Weibull}
\title{Density Plot by Weibull kernel}
\usage{
\method{plot}{Weibull}(x, ...)
}
\arguments{
\item{x}{an object of class "Weibull"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Weibull Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- Weibull(y,200,h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
}
\references{
Salha, R. B., El Shekh Ahmed, H. I., & Alhoubi, I. M. 2014. Hazard Rate Function Estimation Using Weibull Kernel. \emph{Open Journal of Statistics} \strong{4} (08), 650-661.
}
\seealso{
For Gumbel kernel see \code{\link{plot.Gumbel}}. To calculate Weibull estimated values see \code{\link{Weibull}} and for
MSE by using Gumbel Kernel \code{\link{mseweibull}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
