% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SM_QARMAAdditionalFunctions.R
\name{qarma.sim}
\alias{qarma.sim}
\title{Simulation of a \eqn{QARMA(p, q)}-process}
\usage{
qarma.sim(n_x, n_t, model)
}
\arguments{
\item{n_x}{Number of simulated observation rows.}

\item{n_t}{Number of simulated observation columns.}

\item{model}{A list containing the coefficient matrices \code{ar} and 
\code{ma} of the QARMA model as well as the standard deviation of 
innovations \code{sigma}.}
}
\value{
The function returns an object of class \code{"qarma"}, consisting of

 \tabular{ll}{
  \code{Y} \tab A \eqn{n_x \times n_t}{n_x x n_t}-matrix of simulated values
  of the specified QARMA process.\cr
  \code{innov} \tab The innovations used for simulation, iid. drawn from a 
   normal distribution with zero mean and variance 
   \eqn{\sigma^2}{(sigma)^2}.\cr
  \code{model} \tab The model used for simulation, inherited from input.\cr
  \code{stnry} \tab An logical variable indicating whether the simulated 
  model is stationary.\cr
}
}
\description{
\code{qarma.sim} is simulates a specified QARMA-model
 on a lattice, with normally distributed innovations.
}
\section{Details}{

Simulation of a top-left dependent spatial ARMA process (QARMA). This 
function returns an object of class \code{"qarma"}. The simulated innovations
are created from a normal distribution with specified variance
\eqn{\sigma^2}{sigma^2}.

 see the vignette for further details.
}

\examples{
# See vignette("DCSmooth") for examples and explanation
 
ma = matrix(c(1, 0.2, 0.4, 0.1), nrow = 2, ncol = 2)
ar = matrix(c(1, 0.5, -0.1, 0.1), nrow = 2, ncol = 2)
sigma = 0.5
q_model = list(ar = ar, ma = ma, sigma = sigma)

q_sim = qarma.sim(100, 100, model = q_model)
surface.dcs(q_sim$Y)

}
\seealso{
\code{\link{qarma.est}}
}
