% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{dbQuoteLiteral}
\alias{dbQuoteLiteral}
\title{Quote literal values}
\usage{
dbQuoteLiteral(conn, x, ...)
}
\arguments{
\item{conn}{A subclass of \linkS4class{DBIConnection}, representing
an active connection to an DBMS.}

\item{x}{A vector to quote as string.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbQuoteLiteral()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.

When passing the returned object again to \code{dbQuoteLiteral()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
Call these methods to generate a string that is suitable for
use in a query as a literal value of the correct type, to make sure that you
generate valid SQL and protect against SQL injection attacks.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbQuoteLiteral")}
}
\section{Specification}{


The returned expression can be used in a \code{SELECT ...} query,
and the value of
\code{dbGetQuery(paste0("SELECT ", dbQuoteLiteral(x)))[[1]]}
must be equal to \code{x}
for any scalar
integer,
numeric,
string,
and logical.
If \code{x} is \code{NA}, the result must merely satisfy \code{\link[=is.na]{is.na()}}.
The literals \code{"NA"} or \code{"NULL"} are not treated specially.

\code{NA} should be translated to an unquoted SQL \code{NULL},
so that the query \code{SELECT * FROM (SELECT 1) a WHERE ... IS NULL}
returns one row.

}

\examples{
# Quoting ensures that arbitrary input is safe for use in a query
name <- "Robert'); DROP TABLE Students;--"
dbQuoteLiteral(ANSI(), name)

# NAs become NULL
dbQuoteLiteral(ANSI(), c(1:3, NA))

# Logicals become integers by default
dbQuoteLiteral(ANSI(), c(TRUE, FALSE, NA))

# Raw vectors become hex strings by default
dbQuoteLiteral(ANSI(), list(as.raw(1:3), NULL))

# SQL vectors are always passed through as is
var_name <- SQL("select")
var_name
dbQuoteLiteral(ANSI(), var_name)

# This mechanism is used to prevent double escaping
dbQuoteLiteral(ANSI(), dbQuoteLiteral(ANSI(), name))
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
\concept{DBIResult generics}
