% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbDisconnect}
\alias{dbDisconnect}
\title{Disconnect (close) a connection}
\usage{
dbDisconnect(conn, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbDisconnect()} returns \code{TRUE}, invisibly.
}
\description{
This closes the connection, discards all pending work, and frees
resources (e.g., memory, sockets).
}
\section{Specification}{


A warning is issued on garbage collection when a connection has been
released without calling \code{dbDisconnect()}.
A warning is issued immediately when calling \code{dbDisconnect()} on an
already disconnected connection.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbExecute}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
