% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmclustering.R
\name{smooth.hmm}
\alias{smooth.hmm}
\title{Smooth HMM Parameters}
\usage{
smooth.hmm(hmm, smoothing = 1e-04)
}
\arguments{
\item{hmm}{A raw \code{hmm} object (see \code{\link[seqHMM]{build_hmm}}).}

\item{smoothing}{Smoothing parameter for absolute discounting in
\code{\link{smooth.probabilities}}.}
}
\value{
An \code{hmm} object with smoothed probabilities.
}
\description{
Smooth the parameters of an HMM using absolute discounting given a threshold
epsilon. Auxiliary function used in \code{\link{select.seeds}},
\code{\link{assign.clusters}}, and \code{\link{hmm.clust}}.
}
\seealso{
Used in \code{\link{select.seeds}}, \code{\link{assign.clusters}},
  and main function for the DBHC algorithm \code{\link{hmm.clust}}.
}
