% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCV_function.r
\name{dbcv}
\alias{dbcv}
\title{Function that calculates the Density-Based Clustering Validation index (DBCV) of clustering results}
\usage{
dbcv(data, labels, metric = "euclidean", noise_id = -1)
}
\arguments{
\item{data}{input clustering results}

\item{labels}{labels of the clustering}

\item{metric}{metric of the distance, Euclidean by default}

\item{noise_id}{the code of the noise cluster points, -1 by default}
}
\value{
a real value containing the Saturn coefficient
}
\description{
Function that calculates the Density-Based Clustering Validation index (DBCV) of clustering results
}
\examples{

n = 300; noise = 0.05; seed = 1782;
theta <- seq(0, pi, length.out = n / 2)
 x1 <- cos(theta) + rnorm(n / 2, sd = noise)
 y1 <- sin(theta) + rnorm(n / 2, sd = noise)
 x2 <- cos(theta + pi) + rnorm(n / 2, sd = noise)
 y2 <- sin(theta + pi) + rnorm(n / 2, sd = noise)
 X <- rbind(cbind(x1, y1), cbind(x2, y2))
 y <- c(rep(0, n / 2), rep(1, n / 2))

cat("dbcv(X, y) = ", dbcv(X, y), "\n", sep="")
}
