% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_profile.R
\name{plot.model_profile}
\alias{plot.model_profile}
\title{Plot Dataset Level Model Profile Explanations}
\usage{
\method{plot}{model_profile}(x, ..., geom = "aggregates")
}
\arguments{
\item{x}{a variable profile explanation, created with the \code{\link{model_profile}} function}

\item{...}{other parameters}

\item{geom}{either \code{"aggregates"}, \code{"profiles"}, \code{"points"} determines which will be plotted}
}
\value{
An object of the class \code{ggplot}.

\subsection{aggregates}{
\itemize{
 \item{color}{a character. Either name of a color, or hex code for a color,
  or \code{_label_} if models shall be colored, or \code{_ids_} if instances shall be colored}
 \item{size}{a numeric. Size of lines to be plotted}
 \item{alpha}{a numeric between \code{0} and \code{1}. Opacity of lines}
 \item{facet_ncol}{number of columns for the \code{\link[ggplot2]{facet_wrap}}}
 \item{variables}{if not \code{NULL} then only \code{variables} will be presented}
 \item{title}{a character. Partial and accumulated dependence explainers have deafult value.}
 \item{subtitle}{a character. If \code{NULL} value will be dependent on model usage.}
}
}
}
\description{
Plot Dataset Level Model Profile Explanations
}
\examples{
titanic_glm_model <- glm(survived~., data = titanic_imputed, family = "binomial")
explainer_glm <- explain(titanic_glm_model, data = titanic_imputed)
expl_glm <- model_profile(explainer_glm, "fare")
plot(expl_glm)

 \donttest{
library("ranger")
titanic_ranger_model <- ranger(survived~., data = titanic_imputed, num.trees = 50,
                               probability = TRUE)
explainer_ranger  <- explain(titanic_ranger_model, data = titanic_imputed)
expl_ranger <- model_profile(explainer_ranger)
plot(expl_ranger)
plot(expl_ranger, geom = "aggregates")

vp_ra <- model_profile(explainer_ranger, type = "partial", variables = c("age", "fare"))
plot(vp_ra, variables = c("age", "fare"), geom = "points")

vp_ra <- model_profile(explainer_ranger, type = "partial", k = 3)
plot(vp_ra)
plot(vp_ra, geom = "profiles")
plot(vp_ra, geom = "points")

vp_ra <- model_profile(explainer_ranger, type = "partial", groups = "gender")
plot(vp_ra)
plot(vp_ra, geom = "profiles")
plot(vp_ra, geom = "points")

vp_ra <- model_profile(explainer_ranger, type = "accumulated")
plot(vp_ra)
plot(vp_ra, geom = "profiles")
plot(vp_ra, geom = "points")
 }

}
