% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskFiles.R
\name{saveReportTable}
\alias{saveReportTable}
\title{Output R object using function \code{\link{write.csv}}.}
\usage{
saveReportTable(
  x,
  task,
  type,
  ext = "csv",
  subdir = NULL,
  dirCreate = TRUE,
  gzip = FALSE,
  ...
)
}
\arguments{
\item{x}{R object to output.}

\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{Filename type. If the type is an array, the cocatenation of the elements is used with separator"-". Filenames have the form [task name]_[type].[ext]}

\item{ext}{Filename extension.}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{gzip}{unused.}

\item{...}{
  Arguments passed on to \code{\link[utils:write.table]{utils::write.table}}
  \describe{
    \item{\code{file}}{either a character string naming a file or a \link{connection}
    open for writing.  \code{""} indicates output to the console.}
    \item{\code{append}}{logical. Only relevant if \code{file} is a character
    string.  If \code{TRUE}, the output is appended to the
    file.  If \code{FALSE}, any existing file of the name is destroyed.}
    \item{\code{quote}}{a logical value (\code{TRUE} or \code{FALSE}) or a
    numeric vector.  If \code{TRUE}, any character or factor columns
    will be surrounded by double quotes.  If a numeric vector, its
    elements are taken as the indices of columns to quote.  In both
    cases, row and column names are quoted if they are written.  If
    \code{FALSE}, nothing is quoted.}
    \item{\code{sep}}{the field separator string.  Values within each row of
    \code{x} are separated by this string.}
    \item{\code{eol}}{the character(s) to print at the end of each line (row).
    For example, \code{eol = "\r\n"} will produce Windows' line endings on
    a Unix-alike OS, and \code{eol = "\r"} will produce files as expected by
    Excel:mac 2004.}
    \item{\code{na}}{the string to use for missing values in the data.}
    \item{\code{dec}}{the string to use for decimal points in numeric or complex
    columns: must be a single character.}
    \item{\code{row.names}}{either a logical value indicating whether the row
    names of \code{x} are to be written along with \code{x}, or a
    character vector of row names to be written.}
    \item{\code{col.names}}{either a logical value indicating whether the column
    names of \code{x} are to be written along with \code{x}, or a
    character vector of column names to be written.  See the section on
    \sQuote{CSV files} for the meaning of \code{col.names = NA}.}
    \item{\code{qmethod}}{a character string specifying how to deal with embedded
    double quote characters when quoting strings.  Must be one of
    \code{"escape"} (default for \code{write.table}), in which case the
    quote character is escaped in C style by a backslash, or
    \code{"double"} (default for \code{write.csv} and
    \code{write.csv2}), in which case it is doubled.  You can specify
    just the initial letter.}
    \item{\code{fileEncoding}}{character string: if non-empty declares the
    encoding to be used on a file (not a connection) so the character data can
    be re-encoded as they are written.  See \code{\link{file}}.}
  }}
}
\value{
the file name invisibly.
}
\description{
Output R object using function \code{\link{write.csv}}.
}
