% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnewind.R
\name{getnewind}
\alias{getnewind}
\title{Rearranges signaling results matrix with rows in the desired order as outputs}
\usage{
getnewind(fixlabels, results)
}
\arguments{
\item{fixlabels}{- List of strings with desired order of labels}

\item{results}{- Output of call to parsestats}
}
\value{
- Returns a matrix with rows organized in desired order specified by fixlabels
}
\description{
Rearranges signaling results matrix with rows in the desired order as outputs
}
\examples{
\donttest{
#Example starting with obtaining data from Cytobank
library(CytobankAPI)
cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
markersofinterest<-c("CD3","CD56")
popsofinterest<-c("CD4 T cells","NK cells")
exptID=4
type=F
results<-analyzedata(cyto_session,markersofinterest,popsofinterest,exptID,type)
fixlabels<-c("CD4 T cells CD56","NK cells CD56","CD4 T cells CD3","NK cells CD3")
getnewind(fixlabels,results)}

#Example with simple matrix
data<-matrix(1:8,nrow=4,ncol=2,byrow=TRUE)
colnames(data)<-c("Control","Patient")
rownames(data)<-c("NK cells CD3","CD4 T cells CD3","CD4 T cells CD56","NK cells CD56")
fixlabels<-c("CD4 T cells CD56","NK cells CD56","CD4 T cells CD3","NK cells CD3")
getnewind(fixlabels,data)
}
