% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMAP-class.R
\docType{class}
\name{UMAP-class}
\alias{UMAP-class}
\title{S4 UMAP Class}
\value{
A UMAP advanced analysis object
}
\description{
A UMAP object that holds pertinent UMAP advanced analysis run information.
This class should never be called explicitly. If a user would like to create a new Cytobank UMAP object, utilize the \link{dimensionality_reduction.new} function, or any other \link[=dimensionality_reduction]{UMAP endpoints that return UMAP objects documented in the 'Details' section}.
}
\section{Slots}{

\describe{
\item{\code{clustering_channels}}{list the channels selected for the Dimensionality Reduction analysis, this can be either a list of short channel IDs (integer) OR long channel names (character)}

\item{\code{collapse_outliers}}{logical Dimension values that are significant outliers (z-score > 3) will be collapsed to be equal to the min or max value. Try this if you observe that most of the data appears squished within small region}

\item{\code{desired_events_per_file}}{numeric representing the number of desired events per file}

\item{\code{desired_total_events}}{numeric representing the number of desired total events per file}

\item{\code{event_sampling_method}}{character representing the name of event sampling method will be used, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-Dimensionality\%20Reduction-Analysis\%23Event-Sampling#Event-Sampling}{learn more about Event Sampling for Dimensionality Reduction analysis}}

\item{\code{fcsfile_ids}}{list representing the fcs file ids}

\item{\code{gateset_id}}{numeric representing the selected gate id}

\item{\code{min_distance}}{numeric the effective minimum distance between embedded points, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-Dimensionality\%20Reduction-Analysis\%23Event-Sampling#UMAP}{learn more about minimum distance for UMAP analysis}}

\item{\code{num_neighbors}}{numeric the size of local neighborhood (in terms of number of neighboring sample points) used for manifold approximation, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-Dimensionality\%20Reduction-Analysis#UMAP}{learn more about number of neighbors for UMAP analysis}}

\item{\code{normalize_scales}}{logical representing whether or not to normalize scales}
}}

