/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.af.commons.errorhandling.DefaultExceptionHandler;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.tools.OSTools;
import org.af.commons.widgets.InfiniteProgressPanel;
import org.af.commons.widgets.WidgetFactory;
import org.mutoss.config.ClassConfig;
import org.mutoss.config.Configuration;
import org.mutoss.gui.AlgorithmPanel;
import org.mutoss.gui.DesignInputPanel;
import org.mutoss.gui.DesignSelectionPanel;
import org.mutoss.gui.FillTableWorker;
import org.mutoss.gui.MenuBarCrossover;
import org.mutoss.gui.RControl;
import org.mutoss.gui.archive.DesignArchiveControl;
import org.mutoss.gui.dialogs.ErrorDialogSGTK;
import org.mutoss.gui.dialogs.TellAboutOnlineUpate;

public class CrossoverGUI
extends JFrame
implements WindowListener,
ActionListener,
ChangeListener,
ListSelectionListener,
InfiniteProgressPanel.AbortListener,
DocumentListener {
    Configuration conf = Configuration.getInstance();
    public InfiniteProgressPanel glassPane;
    DesignArchiveControl dac;
    public static DecimalFormat df;
    public static final String[] models;
    public static final String[][] parameters;
    public static final int PLACEBOMODEL = 3;
    public static final int PROPORTIONALMODEL = 2;
    DesignSelectionPanel designPanel;
    DesignInputPanel designInputPanel;
    public AlgorithmPanel algorithmPanel;
    JTabbedPane tabbedPane;
    JSpinner spinnerT;
    JSpinner spinnerP;
    JSpinner spinnerS1;
    JSpinner spinnerS2;
    final int maxSp = 99;
    JComboBox jCBmodel;
    JLabel pLabel = new JLabel("Further model parameters:");
    JTextField jtfParam = new JTextField("1");
    ClassConfig ac = new ClassConfig(Configuration.getInstance(), CrossoverGUI.class);
    private boolean lock = true;

    public CrossoverGUI() {
        super("CROSS-OVER DESIGN SEARCH TOOL");
        if (Configuration.getInstance().getGeneralConfig().failSafeMode().booleanValue() && JOptionPane.showConfirmDialog(this, "Reset settings?", "Reset settings?", 0) == 0) {
            Configuration.getInstance().clearConfiguration();
        }
        if (!Configuration.getInstance().getGeneralConfig().failSafeMode().booleanValue() || JOptionPane.showConfirmDialog(this, "Start Logging and Error Handler?", "Logging and error handler", 0) == 0) {
            if (!LoggingSystem.alreadyInitiated()) {
                LoggingSystem.init((String)"/org/mutoss/gui/commons-logging.properties", (boolean)true, (boolean)false, (ApplicationLog)new ApplicationLog());
                ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialogSGTK.class);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultExceptionHandler());
                }
            });
        }
        if (Configuration.getInstance().getGeneralConfig().failSafeMode().booleanValue()) {
            JOptionPane.showMessageDialog(this, "The R enginge will now be initialized.", "Initializing R engine", 1);
        }
        RControl.getRControl(true);
        if (Configuration.getInstance().getGeneralConfig().failSafeMode().booleanValue()) {
            JOptionPane.showMessageDialog(this, "R version will be inspected", "R version", 1);
        }
        try {
            Configuration.getInstance().getGeneralConfig().setRVersionNumber(RControl.getR().eval("paste(R.version$major,R.version$minor,sep=\".\")").asRChar().getData()[0]);
            Configuration.getInstance().getGeneralConfig().setVersionNumber(RControl.getR().eval("Crossover:::CrossoverVersion()").asRChar().getData()[0]);
            this.setTitle("CROSS-OVER DESIGN SEARCH TOOL " + Configuration.getInstance().getGeneralConfig().getVersionNumber());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!Configuration.getInstance().getGeneralConfig().failSafeMode().booleanValue() || JOptionPane.showConfirmDialog(this, "Set Icon and Look'n'Feel?", "Icon and Look and Feel", 0) == 0) {
            this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/gui/rjavaicon64.png")).getImage());
            try {
                this.setLooknFeel();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, "Font size and Look'n'Feel could not be restored.", "Error restoring Look'n'Feel", 0);
            }
        }
        this.glassPane = new InfiniteProgressPanel((JFrame)this, "Calculating");
        this.setGlassPane((Component)this.glassPane);
        this.glassPane.addAbortListener((InfiniteProgressPanel.AbortListener)this);
        this.dac = new DesignArchiveControl();
        this.makeContent();
        this.setJMenuBar(new MenuBarCrossover(this));
        this.pack();
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        if (!Configuration.getInstance().getGeneralConfig().failSafeMode().booleanValue() || JOptionPane.showConfirmDialog(this, "Show GPL?", "GPL", 0) == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!Configuration.getInstance().getGeneralConfig().haveReadGPL()) {
                        new TellAboutOnlineUpate(null);
                        Configuration.getInstance().getGeneralConfig().setTellAboutCheckOnline(true);
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                CrossoverGUI.this.lock = false;
            }
        });
        this.setVisible(true);
    }

    private String getValue(String key, String def) {
        return this.conf.getProperty(key, def);
    }

    private void setValue(String key, String value) {
        this.conf.setProperty(key, value);
    }

    private void makeContent() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getInterface(), c);
        ++c.gridx;
        this.getContentPane().add((Component)this.getModelPanel(), c);
        this.tabbedPane = new JTabbedPane();
        this.designPanel = new DesignSelectionPanel(this);
        this.designInputPanel = new DesignInputPanel(this);
        this.designInputPanel.addActionListener(this);
        this.algorithmPanel = new AlgorithmPanel(this);
        this.tabbedPane.addTab("Catalogue", this.designPanel);
        this.tabbedPane.addTab("Algorithm Search", this.algorithmPanel);
        this.tabbedPane.addTab("Input own design", this.designInputPanel);
        this.tabbedPane.addChangeListener(this);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.tabbedPane, c);
        this.loadDefaults();
        this.newModelSelected();
        this.spinnerT.addChangeListener(this);
        this.spinnerP.addChangeListener(this);
        this.spinnerS1.addChangeListener(this);
        this.spinnerS2.addChangeListener(this);
        this.jCBmodel.addActionListener(this);
        this.stateChanged(null);
    }

    public JPanel getInterface() {
        JPanel panel = new JPanel();
        String cols = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, fill:pref:grow";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerT = new JSpinner(new SpinnerNumberModel(4, 2, 99, 1));
        panel.add((Component)new JLabel("Number of treatments:"), cc.xyw(2, row, 3));
        panel.add((Component)this.spinnerT, cc.xy(6, row));
        this.spinnerP = new JSpinner(new SpinnerNumberModel(4, 2, 99, 1));
        panel.add((Component)new JLabel("Number of periods:"), cc.xyw(2, row += 2, 3));
        panel.add((Component)this.spinnerP, cc.xy(6, row));
        this.spinnerS1 = new JSpinner(new SpinnerNumberModel(4, 2, 99, 1));
        this.spinnerS2 = new JSpinner(new SpinnerNumberModel(8, 2, 99, 1));
        panel.add((Component)new JLabel("Number of sequences:"), cc.xy(2, row += 2));
        panel.add((Component)new JLabel("Min:"), cc.xy(4, row));
        panel.add((Component)this.spinnerS1, cc.xy(6, row));
        panel.add((Component)new JLabel("Max:"), cc.xy(8, row));
        panel.add((Component)this.spinnerS2, cc.xy(10, row));
        return panel;
    }

    public JPanel getModelPanel() {
        CellConstraints cc = new CellConstraints();
        JPanel modelPanel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        modelPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        int row = 2;
        this.jCBmodel = new JComboBox<String>(models);
        modelPanel.add((Component)new JLabel("Model"), cc.xy(2, row));
        modelPanel.add((Component)this.jCBmodel, cc.xy(4, row));
        modelPanel.add((Component)this.pLabel, cc.xy(2, row += 2));
        modelPanel.add((Component)this.jtfParam, cc.xy(4, row));
        this.pLabel.setEnabled(false);
        this.jtfParam.setEnabled(false);
        this.jtfParam.getDocument().addDocumentListener(this);
        return modelPanel;
    }

    public void loadDefaults() {
        this.spinnerS1.getModel().setValue(this.ac.getIntProperty("s1", 4));
        this.spinnerS2.getModel().setValue(this.ac.getIntProperty("s2", 8));
        this.spinnerT.getModel().setValue(this.ac.getIntProperty("t", 4));
        this.spinnerP.getModel().setValue(this.ac.getIntProperty("p", 4));
        this.jCBmodel.setSelectedIndex(this.ac.getIntProperty("CVPattern", 0));
        this.jtfParam.setText(this.ac.getProperty("modelParam", "1"));
    }

    public void saveDefaults() {
        this.ac.setIntProperty("s1", Integer.parseInt(this.spinnerS1.getModel().getValue().toString()));
        this.ac.setIntProperty("s2", Integer.parseInt(this.spinnerS2.getModel().getValue().toString()));
        this.ac.setIntProperty("t", Integer.parseInt(this.spinnerT.getModel().getValue().toString()));
        this.ac.setIntProperty("p", Integer.parseInt(this.spinnerP.getModel().getValue().toString()));
        this.ac.setIntProperty("CVPattern", this.jCBmodel.getSelectedIndex());
        this.ac.setProperty("modelParam", this.jtfParam.getText());
    }

    public void actionPerformed(ActionEvent e) {
        this.saveDefaults();
        if (e.getSource() == this.jCBmodel) {
            this.newModelSelected();
        }
    }

    public double getParam() {
        return Double.parseDouble(this.jtfParam.getText());
    }

    private void newModelSelected() {
        this.algorithmPanel.createEffPanel();
        if (this.jCBmodel.getSelectedIndex() == 3) {
            this.jtfParam.setEnabled(true);
            this.pLabel.setEnabled(true);
            this.pLabel.setText("Number of placebo treatments:");
        } else if (this.jCBmodel.getSelectedIndex() == 2) {
            this.jtfParam.setEnabled(true);
            this.pLabel.setEnabled(true);
            this.pLabel.setText("Proportionality parameter:");
        } else {
            this.jtfParam.setEnabled(false);
            this.pLabel.setEnabled(false);
            this.pLabel.setText("Further model parameters:");
        }
        this.designPanel.valueChanged(null);
        int i = this.designPanel.designTable.getSelectedRow();
        this.designPanel.designTable.getModel().fireTableDataChanged();
        if (i != -1) {
            this.designPanel.designTable.setRowSelectionInterval(i, i);
        }
    }

    public void showFile(String s) {
        File f = new File(RControl.getR().eval("system.file(\"" + s + "\", package=\"Crossover\")").asRChar().getData()[0]);
        if (!f.exists()) {
            throw new RuntimeException("This is strange. The file \"" + s + "\" could not be found.");
        }
        try {
            Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
            Object obj = main.invoke((Object)new Object[0], new Object[0]);
            Method second = obj.getClass().getDeclaredMethod("open", File.class);
            second.invoke(obj, f);
        }
        catch (Exception exc) {
            try {
                if (OSTools.isWindows()) {
                    Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + f.getAbsolutePath());
                    p.waitFor();
                } else {
                    JOptionPane.showMessageDialog(this, "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
            }
        }
    }

    public void windowClosing(WindowEvent e) {
        int answer;
        if (this.dac.designsChanged && (answer = JOptionPane.showConfirmDialog(this, "There are unsaved designs. Should they be saved?", "Unsaved designs", 0)) == 0) {
            this.dac.save(this);
            return;
        }
        if (RControl.getR().eval("exists(\".isBundle\")").asRLogical().getData()[0]) {
            RControl.getR().eval("q(save=\"no\")");
        } else if (System.getProperty("eclipse") != null) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        if (e != null) {
            this.saveDefaults();
        }
        if (e != null && (e.getSource() == this.spinnerS1 || e.getSource() == this.spinnerS2)) {
            int s1 = Integer.parseInt(this.spinnerS1.getModel().getValue().toString());
            int s2 = Integer.parseInt(this.spinnerS2.getModel().getValue().toString());
            int s = Integer.parseInt(this.algorithmPanel.spinnerS.getModel().getValue().toString());
            if (s1 > s2) {
                if (e.getSource() == this.spinnerS1) {
                    this.spinnerS2.getModel().setValue(s1);
                } else {
                    this.spinnerS1.getModel().setValue(s2);
                }
            }
            if (s < s1) {
                this.algorithmPanel.spinnerS.getModel().setValue(s1);
            } else if (s2 < s) {
                this.algorithmPanel.spinnerS.getModel().setValue(s2);
            }
        }
        if (this.tabbedPane.getSelectedIndex() != 0) {
            return;
        }
        this.glassPane.start();
        FillTableWorker worker = new FillTableWorker(this);
        worker.execute();
    }

    public static void startGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new CrossoverGUI();
            }
        });
    }

    public static void main(String[] args) {
        RControl.getR().eval("Sys.setenv(\"JAVAGD_CLASS_NAME\"=\"org/mutoss/gui/JavaGD\")");
        new CrossoverGUI();
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    public void abort() {
    }

    public String getParameters() {
        int t = Integer.parseInt(this.spinnerT.getModel().getValue().toString());
        int p = Integer.parseInt(this.spinnerP.getModel().getValue().toString());
        return "p=" + p + ", v=" + t;
    }

    private void setLooknFeel() throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(Configuration.getInstance().getJavaConfig().getLooknFeel());
        WidgetFactory.setFontSizeGlobal((int)Configuration.getInstance().getGeneralConfig().getFontSize());
        SwingUtilities.updateComponentTreeUI(this);
    }

    public synchronized boolean getLock() {
        if (!this.lock) {
            this.lock = true;
            return true;
        }
        return false;
    }

    public void resetLock() {
        this.lock = false;
    }

    public int getModel() {
        return this.jCBmodel.getSelectedIndex() + 1;
    }

    public void insertUpdate(DocumentEvent e) {
        try {
            this.newModelSelected();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeUpdate(DocumentEvent e) {
        try {
            this.newModelSelected();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changedUpdate(DocumentEvent e) {
        try {
            this.newModelSelected();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        JComponent.setDefaultLocale(Locale.ENGLISH);
        df = new DecimalFormat("#.####");
        models = new String[]{"Standard additive model", "Self-adjacency model", "Proportionality model", "Placebo model", "No carry-over into self model", "Treatment decay model", "Full set of interactions", "Second-order carry-over effects", "No carry-over effects"};
        parameters = new String[][]{{"Treatment", "Carry-over"}, {"Treatment", "Carry-over", "Carry-over (into-self)"}, new String[0], {"Treatment", "Carry-over"}, {"Treatment", "Carry-over"}, {"Treatment", "Carry-over"}, {"Treatment", "Carry-over", "Interaction"}, {"Treatment", "Carry-over (1st order)", "Carry-over (2nd order)"}, new String[0]};
    }
}

