% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\docType{data}
\name{methotrexate}
\alias{methotrexate}
\title{Methotrexate workers}
\format{A data.frame.}
\usage{
data(methotrexate)
}
\description{
Methotrexate is a drug used totreat cancer, but there is concern that it may itself be carcinogenic in healthy individuals who are exposed while either manufacturing or administering the drug.
Deng et al. (2005) compared 21 workers engaged in the production of methotrexate to 21 unexp osed controls matched for age, gender, and smoking. The variables are (prefix "w" means exposed and "c" means control)
\describe{
\item{Mftcr}{mutant frequency of TCR gene}
\item{Mfhrpt}{mutant frequency of hprt gene}
\item{mtl}{mean tail length}
\item{mtm}{mean tail moment}
\item{id}{identifier}
\item{sex}{sex}
\item{age}{age}
\item{smoke}{smoking}
\item{years}{exposure years}
\item{protection}{protection measures, G for gloves, M for mask, N for none}
\item{mask}{if the protection includes mask}
}
}
\references{
Deng, H., Zhang, M., He, J., Wu, W., Jin, L., Zheng, W., ... & Wang, B. (2005). Investigating genetic damage in workers occupationally exposed to methotrexate using three genetic end-points. Mutagenesis, 20(5), 351-357.
}
\keyword{datasets}

