% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_mb_coxmos.R
\name{mb.coxmos}
\alias{mb.coxmos}
\title{Multiblock COX Modeling Function}
\usage{
mb.coxmos(
  method = c("sb.splsicox", "sb.splsdrcox", "sb.splsdrcox_penalty", "sb.splsdacox",
    "isb.splsicox", "isb.splsdrcox", "isb.splsdrcox_penalty", "isb.splsdacox",
    "mb.splsdrcox", "mb.splsdacox"),
  X,
  Y,
  cv.isb = NULL,
  design = NULL,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = TRUE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  MIN_EPV = 5,
  returnData = TRUE,
  verbose = FALSE,
  n.comp = 4,
  penalty = 0.5,
  vector = NULL,
  MIN_NVAR = 1,
  MAX_NVAR = NULL,
  n.cut_points = 5,
  MIN_AUC_INCREASE = 0.01,
  EVAL_METHOD = "AUC",
  pred.method = "cenROC",
  max.iter = 200,
  times = NULL,
  max_time_points = 15
)
}
\arguments{
\item{method}{Modeling method to use: "sb.splsicox", "sb.splsdrcox", "sb.splsdrcox_penalty", "sb.splsdacox",
"isb.splsicox", "isb.splsdrcox", "isb.splsdrcox_penalty", "isb.splsdacox",
"mb.splsdrcox", or "mb.splsdacox".}

\item{X}{List of numeric matrices or data.frames. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{cv.isb}{Instance of class "Coxmos" and isb model. Used to retrieve the
optimal components and variables for the sPLS Cox model
(isb.splsicox, isb.splsdrcox, isb.splsdrcox_penalty and isb.splsdacox).}

\item{design}{Numeric matrix. Matrix of size (number of blocks in X) x (number of blocks in X) with
values between 0 and 1. Each value indicates the strength of the relationship to be modeled between
two blocks; a value of 0 indicates no relationship, 1 is the maximum value. If NULL, auto-design is
computed (default: NULL) (mb.splsdrcox and mb.splsdacox).}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the threshold
(default: 0.05).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}

\item{n.comp}{Numeric. Number of latent components to compute for the (s)PLS model (default: 4).}

\item{penalty}{Numeric. Penalty for variable selection for the individual cox models. Variables
with a lower P-Value than 1 - "penalty" in the individual cox analysis will be keep for the approach
(default: 0.5) (sb.splsicox and sb.splsdrcox_penalty).}

\item{vector}{Numeric vector. Used for computing best number of variables. As many values as
components have to be provided. If vector = NULL, an automatic detection is perform (default: NULL)
(sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{MIN_NVAR}{Numeric. Minimum range size for computing cut points to select the best number of
variables to use (default: 1) (sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{MAX_NVAR}{Numeric. Maximum range size for computing cut points to select the best number of
variables to use. If NULL, the number of variables is selected (default: NULL)
(sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{n.cut_points}{Numeric. Number of cut points for searching the optimal number of variables.
If only two cut points are selected, minimum and maximum size are used. For MB approaches as many
as n.cut_points^n.blocks models will be computed as minimum (default: 5)
(sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{MIN_AUC_INCREASE}{Numeric. Minimum improvement between different cross validation models to
continue evaluating higher values in the multiple tested parameters. If it is not reached for next
'MIN_COMP_TO_CHECK' models and the minimum 'MIN_AUC' value is reached, the evaluation stops
(default: 0.01) (sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{EVAL_METHOD}{Character. The selected metric will be use to compute the best
number of variables. Must be one of the following: "AUC", "IBS" or "C.Index" (default: "AUC")
(sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{pred.method}{Character. AUC evaluation algorithm method for evaluate the model performance.
Must be one of the following: "risksetROC", "survivalROC", "cenROC", "nsROC", "smoothROCtime_C",
"smoothROCtime_I" (default: "cenROC")  (sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{max.iter}{Numeric. Maximum number of iterations for PLS convergence (default: 200)
(sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{times}{Numeric vector. Time points where the AUC will be evaluated. If NULL, a maximum of
'max_time_points' points will be selected equally distributed (default: NULL)
(sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15) (sb.splsdrcox, sb.splsdacox, mb.splsdrcox and mb.splsdacox).}
}
\value{
A Coxmos model of the specified multiblock type.
}
\description{
This function provides a unified interface for all multiblock HD-COX modeling methods in the package.
}
\examples{
data("X_multiomic")
data("Y_multiomic")
X <- X_multiomic
set.seed(123)
index_train <- caret::createDataPartition(Y_multiomic$event, p = .25, list = FALSE, times = 1)
X_train <- X_multiomic
X_train$mirna <- X_train$mirna[index_train,1:30]
X_train$proteomic <- X_train$proteomic[index_train,1:30]
Y_train <- Y_multiomic[index_train,]
mb.coxmos(method = "sb.splsicox", X_train, Y_train, n.comp = 2, x.center = TRUE, x.scale = FALSE)
}
\seealso{
\code{\link{sb.splsicox}} for Single-Block SPLS-ICOX,
\code{\link{sb.splsdrcox_penalty}} for Single-Block SPLS-DRCOX with penalty,
\code{\link{sb.splsdrcox}} for Single-Block SPLS-DRCOX,
\code{\link{sb.splsdacox}} for Single-Block SPLS-DACOX,
\code{\link{isb.splsicox}} for Integrated Single-Block SPLS-ICOX,
\code{\link{isb.splsdrcox_penalty}} for Integrated Single-Block SPLS-DRCOX with penalty,
\code{\link{isb.splsdrcox}} for Integrated Single-Block SPLS-DRCOX,
\code{\link{isb.splsdacox}} for Integrated Single-Block SPLS-DACOX,
\code{\link{mb.splsdrcox}} for Multi-Block SPLS-DRCOX,
\code{\link{mb.splsdacox}} for Multi-Block SPLS-DACOX
}
