% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovTest2.2013Cai.R
\name{CovTest2.2013Cai}
\alias{CovTest2.2013Cai}
\title{Two-Sample Covariance Test by Cai and Ma (2013)}
\usage{
CovTest2.2013Cai(X, Y, alpha = 0.05)
}
\arguments{
\item{X}{an \eqn{(m\times p)}  matrix where each row is an observation from the first dataset.}

\item{Y}{an \eqn{(n\times p)} matrix where each row is an observation from the second dataset.}

\item{alpha}{level of significance.}
}
\value{
a named list containing \describe{
\item{statistic}{a test statistic value.}
\item{threshold}{rejection criterion to be compared against test statistic.}
\item{reject}{a logical; \code{TRUE} to reject null hypothesis, \code{FALSE} otherwise.}
}
}
\description{
Given two sets of data, it performs 2-sample test for equality of covariance matrices where
the null hypothesis is
\deqn{H_0 : \Sigma_1 = \Sigma_2}
where \eqn{\Sigma_1} and \eqn{\Sigma_2} represent true (unknown) covariance
for each dataset based on a procedure proposed by Cai and Ma (2013).
If \code{statistic} \eqn{>} \code{threshold}, it rejects null hypothesis.
}
\examples{
## generate 2 datasets from multivariate normal with identical covariance.
data1 = mvtnorm::rmvnorm(100, sigma=diag(5))
data2 = mvtnorm::rmvnorm(200, sigma=diag(5))

## run test
CovTest2.2013Cai(data1, data2)

}
\references{
\insertRef{cai_optimal_2013}{CovTools}
}
