% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovEst.auto.R
\name{CovEst.auto}
\alias{CovEst.auto}
\title{Estimating Covariance Matrix with automatic tuning}
\usage{
CovEst.auto(X, method = c("Bickel08", "Cai11", "Donoho95", "Fan13", "Qi06"),
  opt = list(nCV = 10, nsearch = 10), parallel = FALSE)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix where each row is an observation from the first dataset.}

\item{method}{a name of estimation method.}

\item{opt}{a list of options containing following fields: \describe{
\item{nCV}{the number for repetitions for 2-fold random cross validation.}
\item{nsearch}{the number of trials on range of regularization parameters.}
}}

\item{parallel}{a logical; \code{TRUE} to use half of available cores, \code{FALSE} to do every computation sequentially.}
}
\value{
a named list containing: \describe{
\item{S}{a \code{(p-by-p)} covariance matrix estimate.}
\item{CV}{a dataframe containing vector of tested threshold values(\code{thr}) and corresponding cross validation scores(\code{CVscore}).}
}
}
\description{
In this variant of \code{\link{CovEst}}, we implemented automatic parameter tuning scheme
applying 2-fold cross validation repeatedly and choosing the minimal one with the least discrepancy.
}
\examples{
## generate data from multivariate normal with Identity covariance.
data = mvtnorm::rmvnorm(100, sigma=diag(5))

## run automatic estimation
sopt = list(nCV=2,nsearch=3) # common option
out1 = CovEst.auto(data, method="Bickel08", opt=sopt)
out2 = CovEst.auto(data, method="Cai11",    opt=sopt)

## Visualize
par(mfrow=c(1,3))
image(pracma::flipud(diag(5)),main="Original Covariance")
image(pracma::flipud(out1$S), main="Bickel08")
image(pracma::flipud(out2$S), main="Cai11")

}
\references{
[Bickel08] Bickel, P. and Levina, E. (2008) \emph{Covariance Regularization by Thresholding.} The Annals of Statistics, Vol.36(6):2577-2604.

[Cai11] Cai, T. and Liu, W. (2011) \emph{Adaptive Thresholding for Sparse Covariance Matrix Estimation.} Journal of the American Statistical Association, Vol.106:672-684.

[Donoho95] Donoho, D. et al. (1995) \emph{Wavelet Shrinkage: Asymptopia?} Journal of the Royal Statistical Society Series B, Vol.57(2):301-369.

[Fan13] Fan. J. et al. (2013) \emph{Large covariance estimation by thresholding principal orthogonal complements.}
Journal of the Royal Statistical Society Series B, Vol.75(4):603-680.

[Qi06] Qi, H. and Sun, D. (2006) \emph{A Quadratically Convergent Newton Method for Computing the Nearest Correlation Matrix.} SIAM J.Matrix Anal.& Appl., Vol.28(2):360-385.
}
\seealso{
\code{\link{CovEst}}
}
