\name{CMData}
\alias{CMData}
\title{Create a `CMdata' object from a data frame.}
\usage{
CMData(x, trt, nresp, clustersize = NULL, freq = NULL)
}
\arguments{
  \item{x}{a data frame with one row representing a cluster
  or potentially a set of clusters of the same size and
  number of responses for each outcome}

  \item{trt}{the name of the variable that defines
  treatment group}

  \item{nresp}{either a character vector with the names or
  a numeric vector with indices of the variables that
  define the number of responses in the cluster for each
  outcome type. If \code{clustersize} is \code{NULL}, then
  it will be calculated assuming that the \code{nresp}
  vector contains all the possible outcomes. If
  \code{clustersize} is given, then an additional category
  is created for the excess cluster members.}

  \item{clustersize}{the name or index of the variable that
  defines cluster size, or \code{NULL}. If \code{NULL}, its
  value will be calculated by adding the counts from the
  \code{nresp} variables. If defined, an additional
  response type will be created for the excess cluster
  members.}

  \item{freq}{the name or index of the variable that
  defines the number of clusters represented by the data
  row. If \code{NULL}, then each row is assumed to
  correspond to one cluster.}
}
\value{
A data frame with each row representing all the clusters
with the same trt/size/number of responses, and
standardized variable names:

\item{Trt}{factor, the treatment group}

\item{ClusterSize}{numeric, the cluster size}

\item{NResp.1--NResp.K+1}{numeric, the number of responses
for each of the K+1 outcome types}

\item{Freq}{numeric, number of clusters with the same
values}
}
\description{
The \code{CMData} function creates an object of class
\dfn{CMData} that is used in further analyses. It
identifies the variables that define treatment group,
clustersize and the number of responses for each outcome
type.
}
\examples{
data(dehp)
dehp <- CMData(dehp, trt="Trt", nresp=c("NResp.1","NResp.2","NResp.3"))
str(dehp)
}
\author{
Aniko Szabo
}
\seealso{
\code{\link{read.CMData}} for creating a \code{CMData}
object directly from a file.
}
\keyword{classes}
\keyword{manip}

