% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fitcopula}
\alias{fitcopula}
\title{Fit copula based bivariate beta-binomial distribution to diagnostic data.}
\usage{
fitcopula(data, SID, copula, formula.se = NULL, formula.sp = NULL,
  formula.omega = NULL, transform.omega = TRUE, param = 1,
  prior.lse = "normal", par.lse1 = 0, par.lse2 = 10,
  prior.lsp = "normal", par.lsp1 = 0, par.lsp2 = 10, prior.omega = NULL,
  par.omega1 = NULL, par.omega2 = NULL, chains = NULL, iter = 6000,
  warmup = 1000, thin = 10, cores = NULL, init = "random",
  seed = sample.int(.Machine$integer.max, 1), ...)
}
\arguments{
\item{data}{A data-frame with no missing values containg TP, TN, FP, FN, 'SID' and co-varaiables(if necessary).}

\item{SID}{A string indicating the name of the column with the study ID.}

\item{copula}{a description of the copula function used to model the correlation between sensitivity and specificty.
This is a string naming the copula function. The choices are "fgm", "frank", "gauss", "c90" and "c270".}

\item{formula.se}{An optional object of class "formula": A symbolic description of a linear model to be fitted to mean E(x) of sensitivity in the logit scale.
the default (when no covariates are included) symbolic description is SID ~ 1 corresponds to the model formula E(x) = mu = exp(a)/(1 + exp(a)) where a is the intercept.
When the covariates are categorical and the relative measures are needed it is important to remove the interecept from the model to obtain meaningful parameters. EG for
a covariate 'Test' with two levels(A and B) and relative sensitivity of B versus A is needed, then the correct formula is SID ~ Test - 1 or SID ~ Test + 0. See \link[stats]{formula}.
For further information on interpretation of parameters in logistic regression see Agresti A(2002) Chapter 5.}

\item{formula.sp}{An optional object of class "formula": A symbolic description of a linear model to be fitted to specificity data.
By default the covariate information for sensitivity is used.}

\item{formula.omega}{An optional object of class "formula": A symbolic description of a linear model to be fitted to the copula function.
By default the covariate information for sensitivity is used.}

\item{transform.omega}{A logical value indicating whether a constrained correlation parameter should be mapped into an non-constrained scale.
This applies to all the allowed copula functions except "frank". The default is TRUE.}

\item{param}{indication of the parameterisation used to map the marginal mean and precision/dispersion to the alpha and beta parameters of the beta distribution.
There are two choices: param=1 which uses \deqn{alpha = mu*phi, beta = (1 - mu)*phi} where \deqn{mu = alpha/(alpha + beta), 0<=mu<=1,} and
\deqn{phi = alpha + beta, phi >=0.}
param=2 uses \deqn{alpha = ((1 - phi)/phi)*mu}
\deqn{beta = ((1 - phi)/phi)*(1 - mu)} where \deqn{mu = alpha/(alpha + beta); 0<=mu<=1,} and
\deqn{phi = 1/( 1 + alpha + beta); 0<=phi<=1.}}

\item{prior.lse}{A description of prior distribution of the marginal mean sensitivity in the logit scale. The default is "normal" distribution.
For other distributions see stan documentation at \url{http://mc-stan.org/documentation/}.}

\item{par.lse1}{A numeric value indicating the location of the prior distribution of the marginal mean sensitivity in the logit scale.
The default is 0 which implying a distribution centered around 0.5 in the 0-1 scale.}

\item{par.lse2}{A numeric value indicating the spread(standard deviation) pf the prior distribution of the marginal mean sensitivity in the logit scale
and can be interpreted as the quantity of prior information.
vague and non-informative priors are specified by a distribution with large variance. The default is sd=10 implying that the variance is 100.}

\item{prior.lsp}{A description of prior distribution of the marginal mean specificity in the logit scale. The default is "normal" distribution.}

\item{par.lsp1}{A numeric value indicating the location of the prior distribution of the marginal mean specificity in the logit scale.
The default is 0 which implying a distribution centered around 0.5 in the 0-1 scale.}

\item{par.lsp2}{A numeric value indicating the spread(standard deviation) pf the prior distribution of the marginal mean specificity in the logit scale
and can be interpreted as the quantity of prior information.
vague and non-informative priors are specified by a distribution with large variance. The default is sd=10 implying that the variance is 100.}

\item{prior.omega}{A description of prior distribution of the correlation parameter(s). The default is "normal" distribution since "transform.omega=TRUE".
When "transform.omega=FALSE" the candidate prior distributions are U[-1, 1] for fgm and gaussian copulas, and half-cauchy(0, 2.5), gamma(0.001, 0.001) for the C90 and C270.}

\item{par.omega1}{A numeric value indicating the location of the prior distribution of the correlation parameter(s). The default is 0.}

\item{par.omega2}{A numeric value indicating the scale/spread(standard deviation) of the prior distribution of the correlation parameter(s). The default is sd=10.}

\item{chains}{A positive numeric value specifying the number of chains, default is 3.}

\item{iter}{A positive numeric value specifying the number of iterations per chain. The default is 6000.}

\item{warmup}{A positive numeric value (<iter) specifying the number of iterations to be discarded(burn-in/warm-up). The default is 1000.}

\item{thin}{A positive numeric value specifying the interval in which the samples are stored. The default is 10.}

\item{cores}{A positive numeric values specifying the number of cores to use to execute parallel sampling. When the hardware has more at least 4 cores,
the default is 3 cores and otherwise 1 core.}

\item{init}{One of digit 0, string "0" or "random", a function that returns a named list, or a list of named list.
"0": initialize all to be zero on the unconstrained support;
"random": randomly generated by Stan.}

\item{seed}{The random number generation seed for Stan. See \link[rstan]{stan} for more details.}

\item{...}{Other oprtional parameters as specified in \link[rstan]{stan}.}
}
\value{
An object which includes a S4 class stanfit. See \link[rstan]{stan} for more details.
}
\description{
Fit copula based bivariate beta-binomial distribution to diagnostic data.
}
\examples{
data(telomerase)
\dontrun{
fit1 <- fitcopula(data=telomerase,
SID = "ID",
copula="fgm",
iter = 4000,
warmup = 1000,
thin = 10,
seed=3,
cores=1)
data(ascus)

fit2 <- fitcopula(data=ascus,
SID = "StudyID",
copula="fgm",
formula.se= StudyID ~ Test - 1,
seed=3)
}

}
\author{
Victoria N Nyaga
}
\references{
{Agresti A (2002). Categorical Data Analysis. John Wiley & Sons, Inc.}

{Clayton DG (1978). A model for Association in Bivariate Life Tables and its Application in
Epidemiological Studies of Familial Tendency in Chronic Disease Incidence. Biometrika,65(1), 141-151.}

{Frank MJ (1979). On The Simultaneous Associativity of F(x, y) and x + y - F(x, y). Aequationes Mathematicae, pp. 194-226.}

{Farlie DGJ (1960). The Performance of Some Correlation Coefficients for a General Bivariate
Distribution. Biometrika, 47, 307-323.}

{Gumbel EJ (1960). Bivariate Exponential Distributions. Journal of the American Statistical Association, 55, 698-707.}

{Meyer C (2013). The Bivariate Normal Copula. Communications in Statistics - Theory and Methods, 42(13), 2402-2422.}

{Morgenstern D (1956). Einfache Beispiele Zweidimensionaler Verteilungen. Mitteilungsblatt furMathematische Statistik, 8, 23 - 235.}

{Sklar A (1959). Fonctions de Repartition a n Dimensions et Leurs Marges. Publications de l'Institut de Statistique de L'Universite de Paris, 8, 229-231.}
}

