% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wms.r
\name{addCopernicusWMSTiles}
\alias{addCopernicusWMSTiles}
\title{Add Copernicus Marine WMS Tiles to a leaflet map}
\usage{
addCopernicusWMSTiles(
  map,
  product,
  layer,
  variable,
  options = leaflet::WMSTileOptions(format = "image/png", transparent = TRUE),
  ...
)
}
\arguments{
\item{map}{A map widget object created from \code{\link[leaflet:leaflet]{leaflet::leaflet()}}}

\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{copernicus_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{copernicus_product_details}}.}

\item{options}{Passed on to \code{\link[leaflet:map-layers]{leaflet::addWMSTiles()}}.}

\item{...}{Passed on to \code{\link[leaflet:map-layers]{leaflet::addWMSTiles()}}.}
}
\value{
Returns an updated \code{map}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Create an interactive map with
\code{leaflet::leaflet()} and add layers of Copernicus marine WMS data
to it.
}
\examples{
\donttest{
leaflet::leaflet() \%>\%
  leaflet::setView(lng = 3, lat = 54, zoom = 4) \%>\%
  leaflet::addProviderTiles("Esri.WorldImagery") \%>\%
  addCopernicusWMSTiles(
    product  = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer    = "cmems_mod_glo_phy-thetao_anfc_0.083deg_P1D-m",
    variable = "thetao"
  )
}
}
\seealso{
Other wms-functions: 
\code{\link{copernicus_wms2geotiff}()},
\code{\link{copernicus_wms_details}()}
}
\author{
Pepijn de Vries
}
\concept{wms-functions}
