% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicGoodValueConcept.R
\name{absolutePublicGoodValue}
\alias{absolutePublicGoodValue}
\alias{absoluteHollerValue}
\title{Compute absolute Public Good value}
\usage{
absolutePublicGoodValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Absolute Public Good value for specified nonnegative game
}
\description{
absolutePublicGoodValue calculates the absolute 
Public Good value for a specified nonnegative TU game. 
Note that in general the absolute Public Good value is not an efficient vector, 
i.e. the sum of its entries is not always 1.
}
\examples{
library(CoopGame)
v <- c(1,2,3,4,0,0,0)
absolutePublicGoodValue(v)

\donttest{
v=c(0,0,0,0.7,11,0,15)
absolutePublicGoodValue(v) 
#[1] 26.7 15.7 26.0
}

}
\references{
Holler M.J. and Li X. (1995) "From public good index to public value. An axiomatic approach and generalization", Control and Cybernetics 24, pp. 257--270

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
