% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Critical_Values}
\alias{CT_Critical_Values}
\title{Critical Values of Concordance and Kruskal Wallis Tests. Exact Method}
\usage{
CT_Critical_Values(Sample_Sizes, H = 0)
}
\arguments{
\item{Sample_Sizes}{Numeric vector (\code{n1},...,\code{nk}) containing the number of repetitions of each element, i.e., the size of each sample in the experiment.}

\item{H}{0 by default. If set to 1, the critical values of the Kruskal-Wallis Test are also calculated and returned.}
}
\value{
The function returns a list with the following elements:
\enumerate{
 \item{ \code{C_results}: Concordance Coefficient results. Critical values and exact p-values for a desired significance levels of 0.1, .05 and .01. }
 \item{ \code{H_results}: Kruskal Wallis results. Critical values and exact p-values for a desired significance levels of 0.1, .05 and .01 (only if H = 1). }
}
}
\description{
This function computes the critical values of the Concordance and Kruskal Wallis Tests. Exact p-value of desired significance levels of .10, .05 and .01.
}
\section{Warning}{

The number of permutations increases rapidly with lenght (Sets). The computational time increases exponetianly with the number of elements and with the number of sets.
}

\examples{
Sample_Sizes <- c(4,4,2)
CT_Critical_Values(Sample_Sizes, H = 1)
}
