% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSensibleHeating.R
\name{calcSensibleHeating}
\alias{calcSensibleHeating}
\title{Calculate Sensible Heating}
\usage{
calcSensibleHeating(Temp1, Temp2, RH = 50, volumeFlowRate)
}
\arguments{
\item{Temp1}{Initial Temperature (°Celsius)}

\item{Temp2}{Final Temperature (°Celsius)}

\item{RH}{Initial Relative Humidity (0-100\%). Optional, default is 50\%.}

\item{volumeFlowRate}{Volume flow rate of air in cubic meters per second (m³/s)}
}
\value{
Sensible heat in kilowatts (kW)
}
\description{
This function calculates sensible heating power.

Sensible heat is the energy that causes an object's temperature to change
without altering its phase, also known as "dry" heat which you can feel.
}
\examples{
calcSensibleHeating(20, 25, 50, 0.5)

calcSensibleHeating(20, 25, 60, 0.5)


}
\seealso{
\code{\link{calcAD}}
}
