% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCoolingCapacity.R
\name{calcCoolingCapacity}
\alias{calcCoolingCapacity}
\title{Calculate Cooling Capacity}
\usage{
calcCoolingCapacity(
  Power,
  power_factor = 0.85,
  safety_factor = 1.2,
  efficiency = 0.7
)
}
\arguments{
\item{Power}{Power consumption in Watts (W).}

\item{power_factor}{Power factor, default is 0.85.}

\item{safety_factor}{Safety factor, default is 1.2 (20\% extra capacity).}

\item{efficiency}{Efficiency of the cooling system, default is 0.7 (70\%).}
}
\value{
Required cooling capacity in kilowatts (kW).
}
\description{
This function calculates the required cooling capacity based on power consumption,
power factor, safety factor, and efficiency.

Cooling capacity is the amount of energy transferred during a cooling process.
}
\examples{
calcCoolingCapacity(1000)

calcCoolingCapacity(1500, power_factor = 0.9, safety_factor = 1.3, efficiency = 0.8)


}
