% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Pois_Dev_LL_Calc}
\alias{Pois_Dev_LL_Calc}
\title{Utility function to perform calculation of Log-Likelihood and Deviation for Poisson Omnibus
\code{Pois_Dev_LL_Calc} Called to perform repeated term and risk calculations}
\usage{
Pois_Dev_LL_Calc(
  reqrdnum,
  totalnum,
  fir,
  R,
  Rd,
  Rdd,
  beta_0,
  RdR,
  RddR,
  Ll,
  Lld,
  Lldd,
  PyrC,
  dev_temp,
  nthreads,
  debugging,
  KeepConstant,
  verbose,
  single_bool,
  start,
  iter_stop,
  dev
)
}
\arguments{
\item{reqrdnum}{total number of free parameters}

\item{totalnum}{total number of parameters}

\item{fir}{st term number}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{beta_0}{parameter estimates}

\item{RdR}{Risk to first derivative ratio matrix}

\item{RddR}{Risk to second derivative ratio matrix}

\item{Ll}{Log-likelihood vector}

\item{Lld}{Log-likelihood first derivative matrix}

\item{Lldd}{Log-likelihood second derivative matrix}

\item{PyrC}{matrix of person-years and event counts}

\item{dev_temp}{temporary storage for deviation calculation}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{verbose}{boolean for additional printing}

\item{single_bool}{boolean for single calculation without derivatives}

\item{start}{starting time for regression}

\item{iter_stop}{binary value used to tell the function not to continue iteration}

\item{dev}{model deviation}
}
\value{
Updates matrices in place: risk storage matrices
}
\description{
Utility function to perform calculation of Log-Likelihood and Deviation for Poisson Omnibus
\code{Pois_Dev_LL_Calc} Called to perform repeated term and risk calculations
}
