% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Calc_Null_LogLik_STRATA}
\alias{Calc_Null_LogLik_STRATA}
\title{Utility function to perform null model equivalent of Calc_LogLik
\code{Calc_Null_LogLik_STRATA} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time}
\usage{
Calc_Null_LogLik_STRATA(
  nthreads,
  RiskFail,
  RiskGroup,
  ntime,
  R,
  Rls1,
  Lls1,
  STRATA_vals,
  Ll,
  ties_method
)
}
\arguments{
\item{nthreads}{number of threads available}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{ntime}{number of risk groups}

\item{R}{risk vector}

\item{Rls1}{First Risk sum storage}

\item{Lls1}{Second Risk sum storage}

\item{STRATA_vals}{vector of strata identifier values}

\item{Ll}{Log-likelihood vector}

\item{ties_method}{Ties method}
}
\value{
Updates matrices in place: Log-likelihood vectors/matrix
}
\description{
Utility function to perform null model equivalent of Calc_LogLik
\code{Calc_Null_LogLik_STRATA} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
}
