% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_permute.R
\name{runTypeI}
\alias{runTypeI}
\title{Run simulations to control type-I error}
\usage{
runTypeI(pl_gwas, n_shift, n_simu, phe_fun = NULL, dist_threshold = 5e+05,
  p_threshold = NULL, collapse_matrix = NULL, rm_shifted_files = TRUE)
}
\arguments{
\item{pl_gwas}{PlGwasC object}

\item{n_shift}{integer. \code{n_shift} for each GCDH run.}

\item{n_simu}{integer. Number of simulations to run.}

\item{phe_fun}{function. Used to generate new phenotype file.}

\item{dist_threshold}{See runGcdh.}

\item{p_threshold}{numeric or NULL. When it's not NULL, the PlGwasC object is filtered by \code{assocFilter} first.}

\item{collapse_matrix}{See runGcdh.}

\item{rm_shifted_files}{See runGcdh.}
}
\value{
A list with the following members: (1) tag of this simulation, can be used to remove related files. (2) 
a list of SNP pairs. If "snp_pair" is a member of the result from \code{phe_fun}, then this list will be non-empty, 
otherwise it will be empty. (3) a list of reports from all the GCDH analysis. (4) global minimal p-values of the single-SNP
approach. (4) global minimal p-values of GCDH.
}
\description{
Simulate a new phenotype N times and run GCDH with each. 
The \code{phe_fun} function is used to generate new phenotype file. 
When this function is not given, the phenotype file from the PlGwasC object will be
permuted and used as the new phenotype file (permutation analysis). Thus when no \code{phe_fun} 
is supplied, this function can be used to survey p-values under the null distribution. 
A threshold for Genome-wide significance can be calculated from these p-values by 5% (or
any other alpha-level) quantile.
}
\author{
Kaiyin Zhong, Fan Liu
}

