% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_climate.R
\name{stations_in_roi}
\alias{stations_in_roi}
\title{Stations in region of interest}
\usage{
stations_in_roi(geometry)
}
\arguments{
\item{geometry}{\code{sf} object containing the geometry for a given ROI.
The geometry can be either a \code{POLYGON} or \code{MULTIPOLYGON}.}
}
\value{
\code{data.frame} object with the stations contained inside the
consulted geometry.
}
\description{
Download and filter climate stations contained inside a region of interest
(ROI).
}
\examples{
\donttest{
lat <- c(5.166278, 5.166278, 4.982247, 4.982247, 5.166278)
lon <- c(-75.678072, -75.327859, -75.327859, -75.678072, -75.678072)
polygon <- sf::st_polygon(x = list(cbind(lon, lat)))
geometry <- sf::st_sfc(polygon)
roi <- sf::st_as_sf(geometry)
stations <- stations_in_roi(roi)
head(stations)
}

}
