% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSurvival.R
\name{estimateSingleEventSurvival}
\alias{estimateSingleEventSurvival}
\title{Estimate survival for a given event of interest using cohorts in the OMOP Common Data Model}
\usage{
estimateSingleEventSurvival(
  cdm,
  targetCohortTable,
  outcomeCohortTable,
  targetCohortId = NULL,
  outcomeCohortId = NULL,
  outcomeDateVariable = "cohort_start_date",
  outcomeWashout = Inf,
  censorOnCohortExit = FALSE,
  censorOnDate = NULL,
  followUpDays = Inf,
  strata = NULL,
  eventGap = 30,
  estimateGap = 1,
  restrictedMeanFollowUp = NULL,
  minimumSurvivalDays = 1
)
}
\arguments{
\item{cdm}{CDM reference}

\item{targetCohortTable}{targetCohortTable}

\item{outcomeCohortTable}{The outcome cohort table of interest.}

\item{targetCohortId}{targetCohortId}

\item{outcomeCohortId}{ID of event cohorts to include. Only one outcome
(and so one ID) can be considered.}

\item{outcomeDateVariable}{Variable containing date of outcome event}

\item{outcomeWashout}{Washout time in days for the outcome}

\item{censorOnCohortExit}{If TRUE, an individual's follow up will be
censored at their cohort exit}

\item{censorOnDate}{if not NULL, an individual's follow up will be censored
at the given date}

\item{followUpDays}{Number of days to follow up individuals (lower bound 1,
upper bound Inf)}

\item{strata}{strata}

\item{eventGap}{Days between time points for which to report survival
events, which are grouped into the specified intervals.}

\item{estimateGap}{Days between time points for which to report survival
estimates. First day will be day zero with risk estimates provided
for times up to the end of follow-up, with a gap in days equivalent
to eventGap.}

\item{restrictedMeanFollowUp}{number of days of follow-up to take into account
when calculating restricted mean for all cohorts}

\item{minimumSurvivalDays}{Minimum number of days required for the main cohort
to have survived}
}
\value{
tibble with survival information for desired cohort, including:
time, people at risk, survival probability, cumulative incidence,
95 CIs, strata and outcome. A tibble with the number of events is
outputted as an attribute of the output
}
\description{
Estimate survival for a given event of interest using cohorts in the OMOP Common Data Model
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(
  cdm = cdm,
  targetCohortTable = "mgus_diagnosis",
  targetCohortId = 1,
  outcomeCohortTable = "death_cohort",
  outcomeCohortId = 1,
  eventGap = 7
)
}

}
