% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{Silhouette_Dissimilarity_Plot}
\alias{Silhouette_Dissimilarity_Plot}
\title{Plot of silhouette widths or dissimilarities}
\usage{
Silhouette_Dissimilarity_Plot(evaluation_object, silhouette = TRUE)
}
\arguments{
\item{evaluation_object}{the output of either a \emph{Cluster_Medoids} or \emph{Clara_Medoids} function}

\item{silhouette}{either TRUE or FALSE, indicating whether the silhouette widths or the dissimilarities should be plotted}
}
\value{
TRUE if either the silhouette widths or the dissimilarities are plotted successfully, otherwise FALSE
}
\description{
Plot of silhouette widths or dissimilarities
}
\details{
This function takes the result-object of the \emph{Cluster_Medoids} or \emph{Clara_Medoids} function and depending on the argument \emph{silhouette} it plots either the dissimilarities or
the silhouette widths of the observations belonging to each cluster.
}
\examples{

# data(soybean)

# dat = soybean[, -ncol(soybean)]

# cm = Cluster_Medoids(dat, clusters = 5, distance_metric = 'jaccard_coefficient')

# plt_sd = Silhouette_Dissimilarity_Plot(cm, silhouette = TRUE)

}
\author{
Lampros Mouselimis
}

