% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{dataR2C}
\alias{dataR2C}
\title{Transform a (normal) data frame to be compatible with \code{\link{ClustMMDD}} main functions}

\usage{
dataR2C(x, ploidy = 1)
}

\arguments{
\item{x}{A data frame or a matrix with the number of columns equal to \eqn{number(variables)*ploidy}.}

\item{ploidy}{The number of unordered observations represented by a string in \code{xdata}. For example, for genotypic data from diploid individual, \eqn{ploidy = 2} : two columns for one variable.}
}
\value{
A list of elements needed for \code{\link{ClustMMDD}} main functions :
	\itemize{
		\item{data : }{A matrix compatible with \code{\link{ClustMMDD}} main functions.}
		\item{ploidy : }{The number of columns for each variable. It is the ploidy for genotypic data}
		\item{N : }{The number of lines in x.}
		\item{P : }{The number of categorical variables describing the dataset : \eqn{P = ncol(x)/ploidy}.}
		\item{N_LEVELS : }{The vector of the numbers of levels for the variables.}
		\item{LEVELS : }{The levels for the variables.}
		\item{COUNT : }{The observed counts of the levels.}
		\item{FREQ : }{The observed frequencies.}
	}
}
\description{
\code{dataR2C(x, ploidy)} returns a list.
}

\examples{
data(genotype1)
head(genotype1)
genotype2 = cutEachCol(genotype1[, -11], 2)
head(genotype2)
genotype3 = dataR2C(genotype2, ploidy = 2)
head (genotype3$data)
str(genotype3)
}
\author{
Wilson Toussile
}
\seealso{
\code{\link{cutEachCol}} in \code{\link{ClustMMDD}} package.
}

