% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.assign.torus.R, R/methods.R
\name{cluster.assign.torus}
\alias{cluster.assign.torus}
\alias{plot.cluster.obj}
\title{Clustering by connected components of ellipsoids}
\usage{
cluster.assign.torus(icp.object, level = NULL)

\method{plot}{cluster.obj}(x, assignment = "outlier", overlay = FALSE, out = FALSE, ...)
}
\arguments{
\item{icp.object}{an object must be an \code{icp.torus} object, which contains
all values to compute the conformity score constructed with \code{icp.torus},
or a \code{hyperparam.torus} object which is generated by \code{hyperparam.torus}.}

\item{level}{a scalar in \eqn{[0,1]}. If argument \code{icp.object} is an \code{icp.torus} object,
the default value for \code{level} is 0.1. If argument \code{icp.object} is
a \code{hyperparam.torus} object and \code{level = NULL}, then \code{level}
is set as the optimal level \code{hyperparam.torus$alphahat}.}

\item{x}{\code{cluster.obj} object}

\item{assignment}{A string. One of "outlier", "log.density", "posterior", "mahalanobis". Default is "outlier".}

\item{overlay}{A boolean index which determines whether plotting ellipse-intersections on clustering plots.
Default is \code{FALSE}.}

\item{out}{An option for returning the ggplot object. Default is \code{FALSE}.}

\item{...}{additional parameter for ggplot2::ggplot()}
}
\value{
clustering assignment for data, given \code{icp.torus} objects
\describe{
  \item{\code{cluster.id.by.log.density}}{cluster assignment result based on approximate log-density.}
  \item{\code{cluster.id.by.posterior}}{cluster assignment result based on the posterior probability.}
  \item{\code{cluster.id.outlier}}{cluster assignment result which regards data not included in conformal prediction set
  as outliers.}
  \item{\code{cluster.id.by.Mah.dist}}{cluster assignment result based on Mahalanobis distance.}
  \item{\code{level}}{used level which determines the size of clusters(conformal prediction set).}
  \item{\code{data}}{input data which are assigned to each cluster.}
  \item{\code{icp.torus}}{\code{icp.torus} object which is used for cluster assignment.}
}
}
\description{
\code{cluster.assign.torus} returns clustering assignment for data
  given \code{icp.torus} objects, which can be constructed with
  \code{icp.torus}.

\code{plot.clus.torus} plots clustering results, which is given by \code{cluster.obj} object, with some options.
}
\examples{
data <- toydata1[, 1:2]
icp.torus <- icp.torus(data, model = "kmeans",
                       kmeansfitmethod = "general",
                       J = 4, concentration = 25)
level <- 0.1

cluster.assign.torus(icp.torus, level = level)
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction" to appear in Annals of Applied Statistics.

  I.  Gilitschenski  and  U.  D.  Hanebeck.   "A  robust  computational  test  for  overlap  of  two
    arbitrary-dimensional ellipsoids in fault-detection of kalman filters". In 2012 15th International Conference onInformation Fusion, pages 396–401.
}
\seealso{
\code{\link[ClusTorus]{icp.torus}}, \code{\link[ClusTorus]{hyperparam.torus}}
}
